"""
MagPy
LaTeX Table output filter
Written by Roman Leonhardt December 2012
- contains write function for hour data

ToDo: use longer files (anaylsze full year data if only monthly files are available
ToDo: add table footer

"""

from magpy.stream import *
from magpy.opt.Table import Table

def writeLATEX(datastream, filename, **kwargs):
    """
    Writing WDC format data.
    """
    
    mode = kwargs.get('mode')
    keys = kwargs.get('keys')

    if not keys:
        keys = ['x','y','z','f']
    header = datastream.header
    iagacode = header.get('IAGAcode',"").upper()
    caption = header.get('TEXcaption',"")
    label = header.get('TEXlabel',"")
    justs = header.get('TEXjusts',"") # e.g. 'lrccc'
    rotate = header.get('TEXrotate',False)
    tablewidth = header.get('TEXtablewidth',"")
    tablenum = header.get('TEXtablenum',"")
    fontsize = header.get('TEXfontsize',"")

    if not tablewidth:
        tablewidth = '0pt'
    if not fontsize:
        fontsize = '\\footnotesize'
    
    if mode == 'wdc':
        # 1. determine sampling rate
        samplinginterval = datastream.get_sampling_period()
        # get difference between first and last time in days
        deltat = datastream[-1].time - datastream[0].time
        if 0.8 < samplinginterval/30.0 < 1.2:
            srange = 12
            sint = 'month'
            sintprev = 'year'
            datestr = '%Y'
            sideheadstr = ''
        elif 0.8 < samplinginterval < 1.2:
            srange = 31
            sint = 'day'
            sintprev = 'month'
            datestr = '%m'
            sideheadstr = '%Y'
        elif 0.8 < samplinginterval*24 < 1.2:
            srange = 24
            sint = 'hour'
            sintprev = 'day'
            datestr = '%b%d'
            sideheadstr = '%Y'
        elif 0.8 < samplinginterval*24*60 < 1.2:
            srange = 60
            sint = 'minute'
            sintprev = 'hour'
            datestr = '%H'
            sideheadstr = '%b%d %Y'
        elif 0.8 < samplinginterval*24*3600 < 1.2:
            srange = 60
            sint = 'second'
            sintprev = 'minute'
            datestr = '%H:%M'
            sideheadstr = '%b%d %Y'
        else:
            logging.error('Could not determine sampling rate for latex output: samplinginterval = %f days' % samplinginterval) 
            return
        numcols = srange+1

        headline = np.array(range(srange+1)).tolist()
        headline[0] = sintprev
        headline.append('mean')
        if not justs:
            justs = 'p'*(numcols+1)

        fout = open( filename, "wb" )
        t = Table(numcols+1, justs=justs, caption=caption, label=label, tablewidth=tablewidth, tablenum=tablenum, fontsize=fontsize, rotate=True)
        t.add_header_row(headline)

        for key in keys:
            # exec('...' % key) 
            # here starts the key dependend analysis
            exec('%sarray = np.empty((srange+1,int(np.round(float(len(datastream))/float(srange))),))' % key)
            exec('%sarray[:] = np.NAN' % key)
            exec('%sarray = %sarray.tolist()' % (key,key)) # using list, so that strings can be used
            # get means and variation:
            exec('%sar = np.array([elem.%s for elem in datastream if not isnan(elem.%s)])' % (key,key,key))
            exec('m%s = np.floor(np.min(%sar)/100)*100' % (key,key))
            if np.max(eval(key+'ar')) - eval('m'+key) < 1000:
                sigfigs = 3

            for elem in datastream:
                dateobj = num2date(elem.time).replace(tzinfo=None)
                currx = eval('dateobj.'+sint) + 1
                curry = eval('dateobj.'+sintprev)-1
                datecnt = datetime.strftime(num2date(elem.time).replace(tzinfo=None),datestr)
                exec('%sarray[0][curry] = datecnt' % key)
                exec('%sarray[currx][curry] = elem.%s-m%s' % (key,key,key))

            mecol = []
            addcollist = eval(key+'array')
            tmpar = np.array(addcollist)
            tmpar = np.transpose(tmpar)
            for i in range(len(tmpar)):
                meanlst = []
                for j in range(len(addcollist)):
                    meanlst.append(addcollist[j][i])
                try:
                    if len(meanlst) > 24:
                        median = np.mean(meanlst[1:])
                    else:
                        median = float(NaN)
                except:
                    median = float(NaN)
                    pass
                mecol.append(median)
            addcollist.append(mecol)
            numcols = numcols+1

            label = datetime.strftime(num2date(elem.time).replace(tzinfo=None),sideheadstr) + ', Field component: ' + key + ', Base: ' + str(eval('m'+key)) + ', Unit: ' + 'nT'
            t.add_data(addcollist, label=label, labeltype='side', sigfigs=0)

        t.print_table(fout)
        fout.close()
    else:
        numcols = len(keys)+1
        if not justs:
            justs = 'l'*numcols
        headline = ['Date']
        samplinginterval = datastream.get_sampling_period()
        if 0.8 < samplinginterval/365.0 < 1.2:
            datestr = '%Y'
        elif 0.8 < samplinginterval/30.0 < 1.2:
            datestr = '%Y-%m'
        elif 0.8 < samplinginterval < 1.2:
            datestr = '%Y-%m-%d'
        elif 0.8 < samplinginterval*24 < 1.2:
            datestr = '%Y-%m-%dT%H:%M'
        else:
            datestr = '%Y-%m-%dT%H:%M:%S.%f'
        col1tmp = datastream._get_column('time')
        col1 = []
        for elem in col1tmp:
            col1.append(datetime.strftime(num2date(elem),datestr))
        addcollist = [col1]
        for iter,key in enumerate(keys):
            # extract headers
            colhead = header.get('col-'+key," ")
            if not header.get('unit-col-'+key,'') == '':
                colhead = colhead+' $['+header.get('unit-col-'+key,'')+']$'
            headline.append(colhead)
            # Extract data and time columns 
            column = str(iter+2)
            exec('col'+ column + ' = datastream._get_column(\'' + key + '\')') 
            addcollist.append(eval('col'+ column))

        fout = open( filename, "wb" )
        t = Table(numcols, justs=justs, caption=caption, label=label, tablewidth=tablewidth, tablenum=tablenum, fontsize=fontsize, rotate=rotate)
        t.add_header_row(headline)
        #col3 = [[0.12345,0.1],[0.12345,0.01],[0.12345,0.001]]
        t.add_data(addcollist, sigfigs=3)
        t.print_table(fout)
        fout.close()

