# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Plugin for efukt.com videos.
"""


from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import SimpleFormat


__all__ = ("Efukt",)


class EfuktMedium(HTMLMedium):

    """A video on efukt.com."""

    url_format = "http://efukt.com/%s.html"

    @property
    def title(self):
        """Video title."""
        return self.page.xpath("//div[@id='movie_title']/text()")[0].strip('"')

    def __iter__(self):
        """Iterate formats."""
        yield SimpleFormat(url=self.get_content_substring(\
                "flashvars.file = \"", "\";"))


class Efukt(HTMLPlugin):

    """Plugin for efukt.com videos."""

    url_format = "http://efukt.com/%s.html"
    medium_class = EfuktMedium
