# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""CineGratis24h plugin for GetMediumURL."""


from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import Format


__all__ = ("CineGratis24h",)


class CineGratis24hMedium(HTMLMedium):

    """A video on CineGratis24h."""

    url_format = "http://www.cinegratis24h.com/%s"

    def __iter__(self):
        """Iterate formats."""
        yield Format(url=self.get_content_substring("file=", ".mp4"))


class CineGratis24h(HTMLPlugin):

    """Plugin for CineGratis24h."""

    url_format = "http://www.cinegratis24h.com/%s"
    medium_class = CineGratis24hMedium
