# -*- coding: utf-8 -*-

import os
import unittest
import pytz
from datetime import datetime

from gitlayer import fileobj

class TestFileObj(unittest.TestCase):

    def test_fileobj(self):
        d = os.urandom(32)
        f = fileobj.GitLayerFile()
        f._groups.add('c')
        f._groups.add('b')
        f._groups.add('a')
        f._tags.add('c')
        f._tags.add('b')
        f._tags.add('a')
        f.content = d
        f.timezome = pytz.utc
        n = datetime.utcnow()
        f.date = n
        f.do_jinja = True
        self.assertEqual(f.groups, ['a', 'b', 'c'])
        self.assertEqual(f.tags, ['a', 'b', 'c'])
        self.assertTrue(f.dynamic)
        self.assertEqual(f.content, d)
        self.assertEqual(f.localise_date(n), n)

    def test_fileblocks(self):
        d = os.urandom(32)
        b = fileobj.GitLayerBlocks()
        b.a = d
        self.assertEqual(b.a, d)

# eof