# Template metadata statement: uri

The `uri` template tag allows you to remap a URI for a page. For example in a
template:

```html
{% uri '/anotheruri.html' %}
```

If the above example was in a page called `/someuri.html` it would be remapped to
be accessible through `/anotheruri.html` in the browser. The original URI would
return a 404 error.

You will see a notication of the remapping in your development console window:

```bash
INFO | remapped /someuri.html -> /anotheruri.html
```

**Note** you cannot replace a physical file with a `{% uri '...' %}` remapping or
map two files to the same URI. If you attempt this you will see an error in the
development console window:

```bash
ERROR | failed to remap /someuri.html -> /anotheruri.html, already in use
```

If such a conflict occurs the page will be available at its original URI.

**Note** this statement returns nothing (an empty string) to the template.
