# Template statement: concat

Files of the same MIME type such as `text/css` can be concatenated together
automatically. This reduces the number of requests browsers make to your site and
makes your site faster. You can simply seperate file requests by commas for files
of the same type inside the `{% concat ... %}` statement:

```html
<link rel="stylesheet" href="{% concat '/styles/a-file.css', '/styles/another-file.css' %}">
```

The output of this statement is a special dynamic URI that when requested contains
the contents of both files added together into a single file. This is post-rendering
meaning you can combine Jinja2 HTML templates with plain HTML as well as combine
SCSS/SASS CSS with normal CSS, for example:

```html
<link rel="stylesheet" href="{% concat '/styles/normal-file.css', '/styles/sass-file.scss' %}">
```

Note the `scss` dynamic SASS file extension for the second file.

You can combine arbitrary file types using this feature providing they have the same
MIME type, however it makes no sense for most binary data formats. This feature is
designed for CSS and JavaScript files to be merged into single resources
automatically for speed only.

This example would render in the template with the following returned URI:

```html
<link rel="stylesheet" href="/styles/normal-file.css,/styles/sass-file.scss">
```

**Note** the concatenated request will return a 404 error of the MIME types of all
the files in the concat statement do not match.

**Note** if you happen to have a real physical file or a `{% uri ... %}` remap with
the same URI as the output of this statement they will take precedence.