# Template filter: dateformat

The `|dateformat` filter lets you specify the format for dates to be displayed. By
default dates will be displayed in 'ISO' format, such as if you do:

```html
<p>This files date: {{ this.date }}</p>
```

It will render as:

```html
<p>This files date: 2014-06-30 11:14:45.438546</p>
```

... which is almost certainly not what you want. You can use datefilter to format
the date as required using what Python calls 'directives'. For example:

```html
<p>This files date: {{ this.date|dateformat('%A %d %Y') }}</p>
```

In this case, `%A` means 'day of the week', `%d` means 'day of the month' and `%Y`
means 'full year'. The case is important. It will render as:

```html
<p>This files date: Monday 30 2014</p>
```

You can find a complete list of the `%A` `%d` and other formatting directives here:

> https://docs.python.org/2/library/datetime.html#strftime-and-strptime-behavior

Using the directives you can format a date in any way you need. If you are working
on a foreign language site and you don't want `%A` to return Monday but the day of
the week in your native language you can do this with the `{% locale '...' %}`
metadata statement on a per-page basis.
