# Template function: nextpost

The `nextpost()` function takes a file object as an argument and returns the next
post. Note this may return `None` if there is no next post.

```html
<p>The next post to this page is...</p>
{% with next = nextpost(this) %}
    {% if next %}
    <p>{{ next.uri }}</p>
    {% endwith %}
{% endwith %}
```

You can also specifcy groups and tags to filter which post is next. This allows
you to specify 'the next blog post with a tag set' and so on.

```html
<p>The next post to this page with the group 'blog' and the tag 'hi' is...</p>
{% with next = nextpost(this, groups='blog', tags='hi') %}
    {% if next %}
    <p>{{ next.uri }}</p>
    {% endwith %}
{% endwith %}
```

**Note** as with all the other filtering functions you can use `groups='groupname'`
or a list for multiple tags or groups like `groups=['group1', 'group2']`.
