# YAML and markdown

GitLayer supports a similar syntax for metadata with markdown to most other static
site engines. This allows for pure markdown files to be written and rendered in
templates in your sites. YAML headers are entirely optional. If no URI is but a
header is present then an automatic URI will be generated for you. Here is an
example:

```html
---
extends: _base.html
date: 2014-08-22
tags: tag, another tag
title: page title that maps to {% block title %} in jinja
block.something: arbitrary Jinja2 block
---

# markdown content

* this is a list
```

The above file would be automatically remapped for you to the following URI:

> `2014-08-22_page-title-that-maps-to-block-title-in-jinja.html`

if a date is set. If no date is set the autogenerated URI would be:

> `page-title-that-maps-to-block-title-in-jinja.html`

if a page happens to already exist at that URI then it is not remapped.

The valid YAML tokens are:

| Token       | Description                                                        |
| ----------- | ------------------------------------------------------------------ |
| uri         | Remap the URI of the markdown content to a new URI                 |
| extends     | Specifies the base Jinja2 template to extend from                  |
| date        | Date of the file, such as `2014-08-22`                             |
| title       | The page title, also set for you in a {% block title %}            |
| groups      | String of comma seperated groups to assign to the page             |
| tags        | String of comma seperated tags to assign to the page               |
| timezone    | Usually not reuqired, timezone as a string such as `Europe\London` |
| locale      | Usually not reuqired, locale as a string such as `en_GB.UTF-8`     |
| parent      | Set the parent URI to this page                                    |
| block.*     | Maps to an arbitrary block in a Jinja2 template                    |

You can use Jinja2 syntax in markdown files with HTML if you escape it with \{% and
%\}. As Jinja rendering happens after markdown you can only use HTML and not
markdown rendering. For example:

```html
# this is some markdown

more markdown

\{% for tag in this.tags %\}
<p>{{ tag }}</p>
\{% endfor %\}

> back to markdown again
```

**Note** all other metadata set in a YAML header are ignored.