# GitLayer development server

The GitLayer development server is the open source version of the production
renderer used on GitLayer.com. GitLayer is a static site generation tool with
optionally attached hosting platform that can be used to quickly build sites using
popular existing packages.

The GitLayer development server and the GitLayer service relies on the following
excellent open source projects who have our thanks:

> [Jinja2](http://jinja.pocoo.org/)

> [pyScss](https://github.com/Kronuz/pyScss)

> [markdown](http://pythonhosted.org/Markdown/)

> [csscompressor](https://github.com/sprymix/csscompressor)

> [slimit](http://slimit.readthedocs.org)


## Summary

The GitLayer development server is a simple web server that is appropriate for use
in a local development environment. It is based on Python's bundled HTTPServer and
uses Jinja2 for HTML templating with a number of extensions as well as pyScss for
rendering CSS files.


## Installation

You can install the GitLayer development server and all its dependancies directly
from PyPI and pip:

```bash
$ pip install gitlayer
```

## Manual installation and requirements

If you choose to install the package manually or ignore the dependancies you will
need to install a number of required Python modules, all of which are available via
PyPI and pip. They are installable with:

```bash
$ pip install --upgrade jinja2 markdown pyScss python-dateutil pytz pyyaml slimit
```


## Usage

Once installed with pip, easy_install or manually you should have an executable in
your path called `gitlayer`. Simply change to your site directory and run it:

```bash
$ cd /path/to/your/site
$ gitlayer
INFO | attempting to serve directory /path/to/your/site
INFO | GitLayer development server listening on: http://127.0.0.1:8000/
INFO | Use control+c to stop
```

This will start an HTTP server on localhost listening on port 8000. You can supply
an optional parameter to change the port or host, such as:

```bash
$ gitlayer 8001
```

or

```bash
$ gitlayer 10.0.0.123:8888
```

or

```bash
$ gitlayer -r /path/to/some/site 8001
```

You can override the usage of the current working directory as in the above example
as well as precisely specify the host and port using the following arguments:

```bash
$ gitlayer --help
GitLayer local server arguments:
 -h --help      This help message
 -v --version   Prints the GitLayer installation version number
 -b --bind      IP or host to bind the server to, defaults to 127.0.0.1
 -p --port      Port number to listen on, defaults to 8000
 -r --root      Directory to serve, defaults to the current working dir
 -o --out       Path to a directory to save a rendered copy of the site
 -d --delete    When combined with -o the output directory is deleted first
```

You can also use the python module syntax to start the GitLayer development server
which is identical to the using the standard `gitlayer` command:

```bash
$ python -m gitlayer
```


## Reference documentation

You can read up on complete documentation of all features here:

> [GitLayer reference documenation](https://github.com/gitlayer/gitlayer/docs)


## Tests

You can use the usual `python setup.py test` syntax to run the test suite.


## Contributing

Contributions are welcome, please see the
[CONTRIBUTING](https://github.com/gitlayer/gitlayer/blob/master/CONTRIBUTING) guide.
