# GitLayer reference documentation


## Building sites

A local development server that simply passes HTML through Jinja2 templating
language is not too useful for purely static site building. The GitLayer development
server extends Jinja2 with custom tags and blocks which allow you to build a much
richer site with more powerful functions to access the properties of your sites.

To have files processed by Jinja2 automatically simply give them the file extension
`.html`. To have files processed by pyScss simply give them the file extension
`.scss.css`. All processing is done automatically. You do not have to restart the
development server when making changes to static files, these changes are detected
automatically.

When using GitLayer it is advisable to understand the expected workflow before
starting to build a site. You should be comfortable with using Jinja2 style (or at a
push, Django style) templates. Simply put, we extend Jinja2 to provide powerful
functions that extract data from other files in your site in each template.

The idea is to chain the extensions below to allow automatic updates to your sites.
For example. this means that adding a page to a group will affect a list of all
groups on other pages. While the end resulting site is statically generated, the
manipulation of the pages can be quite dynamic and rivals most site generation and
blogging software.

Some elements used in GitLayer site development are Python-like (such as using
`datetime()` objects or referring to arrays as `lists`), but you do not need to know
Python to use GitLayer. Any Python-like usage is extremely minimal, don't be scared!


## Jinja2

We advise fully reading the excellent documentation provided by the Authors of
Jinja2 if you are new to the templating language, available here:

> http://jinja.pocoo.org/docs/

We provide each rendered template with a custom context allowing to replace the
context you would normally provide Jinja2 from your own data sources.


## pyScss

pyScss is an implementation of the SCSS/Sass extensions to CSS3. Its usage is
(mostly) identical to the reference implementation of SCSS. You can read
documentation on using SCSS here:

> http://sass-lang.com/documentation/file.SASS_REFERENCE.html#css_extensions

**Note** you do not need to install the Ruby version of Sass.


### Jinja2 GitLayer extensions

Bundled in with the implementation of Jinja2 are a number of custom extensions that
provide additional functionality useful for static site building. We use these to
offer a clean way to set metadata for files which can be used in the rest of the
site as well as extending some features.

**Note** all metadata is inheriable. If you assign groups, tags, dates, timezones
etc. to a template and then extend that template all the child templates inherit the
same metadata. You can overwrite dates, timezones and so on in child templates.

Groups and tags are a little different in that they are *extended*. This means
that if you have a file called `page.html` which extends `_base.html` then it will
have all the groups and tags from *both* `page.html` *and* `_base.html`. This
allows group tagging.

When using GitLayer we use the following definitions:

| Name        | Definition                                                         |
| ----------- | ------------------------------------------------------------------ |
| file        | An object that represents a single file in your site.              |
| page        | A file object for files that are HTML files                        |
| post        | A file object that are HTML files with a defined date              |

**Note** it is important you understand the concept of the file objects used by
GitLayer. Detailed documenation on GitLayer file objects can be found here:

> [Using GitLayer file objects in templates](https://github.com/gitlayer/gitlayer/blob/master/docs/file-objects.md)


### Jinja2 custom context

Each template in your site has access to the following variables and functions:

| Variable    | Description                                                        |
| ----------- | ------------------------------------------------------------------ |
| this        | The current template as a file object                              |
| groups      | List of all groups in your site                                    |
| tags        | List of all tags set in your site                                  |
| files       | List of file objects for every file in your site                   |
| pages       | List of file objects for every HTML file in your site              |
| posts       | List of file objects for every post in your site                   |
| pathmatch   | Function that returns a list of files that match a path            |
| tagmatch    | Function that returns a list of files that match a list of tags    |
| groupmatch  | Function that returns a list of files that match a list of groups  |
| byuri       | Function that returns a single file object if one matches the URI  |
| datetree    | Function that converts the supplied list of files into a date tree |
| datematch   | Function that returns only the matching files within a date range  |
| filesort    | A special sort() that works on lists of files                      |
| nextpost    | Get the next post by date                                          |
| previouspost | Get the previous post by date                                     |
| now         | The current date as a `datetime()` instance                        |
| utcnow      | The current date in UTC as a `datetime()` instance                 |


## CSS and JavaScript minification

GitLayer supports automatic compression of JavaScript and CSS. Documentation:

> [Automatic JavaScript and CSS compression](https://github.com/gitlayer/gitlayer/blob/master/docs/code-compression.md)


## 'Magic' URLs

GitLayer supports some URIs that are automatically generated for you. Documenation:

> [Magic URIs documentation](https://github.com/gitlayer/gitlayer/blob/master/docs/magic-uris.md)


## YAML and markdown

GitLayer supports metadata associated with pure markdown content as headers. Documentation:

> [YAML and markdown](https://github.com/gitlayer/gitlayer/blob/master/docs/markdown-yaml.md)


## Reference documentation pages for Jina2 extensions

### Block extensions

> [`{% groups %}{% endgroups %}` metadata block extension to group pages](https://github.com/gitlayer/gitlayer/blob/master/docs/block-groups.md)

> [`{% markdown %}{% endmarkdown %}` metadata block extension to render markdown in pages](https://github.com/gitlayer/gitlayer/blob/master/docs/block-markdown.md)

> [`{% tags %}{% endtags %}` metadata block extension to tag pages](https://github.com/gitlayer/gitlayer/blob/master/docs/block-tags.md)

### Statement extensions

> [`{% concat ... %}` concatenate multiple files into a single request](https://github.com/gitlayer/gitlayer/blob/master/docs/statement-concat.md)

> [`{% date ... %}` metadata statement to set a pages date](https://github.com/gitlayer/gitlayer/blob/master/docs/statement-date.md)

> [`{% locale ... %}` metadata statement to set a pages locale](https://github.com/gitlayer/gitlayer/blob/master/docs/statement-locale.md)

> [`{% parent ... %}` metadata statement to set a pages parent page](https://github.com/gitlayer/gitlayer/blob/master/docs/statement-parent.md)

> [`{% timezone ... %}` metadata statement to set a pages timezone](https://github.com/gitlayer/gitlayer/blob/master/docs/statement-timezone.md)

> [`{% uri ... %}` metadata statement to remap a pages URI](https://github.com/gitlayer/gitlayer/blob/master/docs/statement-uri.md)

### Filter extensions

> [`{{ ...|bytestokilo }}` filter to convert bytes to kilobytes](https://github.com/gitlayer/gitlayer/blob/master/docs/filter-bytestokilo.md)

> [`{{ ...|bytestomega }}` filter to convert bytes to megabytes](https://github.com/gitlayer/gitlayer/blob/master/docs/filter-bytestomega.md)

> [`{{ ...|dateformat }}` filter format datetime objects](https://github.com/gitlayer/gitlayer/blob/master/docs/filter-dateformat.md)

### Function extensions

> [`{{ byurl(...) }}` function to get pages by their URI](https://github.com/gitlayer/gitlayer/blob/master/docs/function-byuri.md)

> [`{{ datematch(...) }}` function to filter a list of pages by a date range](https://github.com/gitlayer/gitlayer/blob/master/docs/function-datematch.md)

> [`{{ datetree(...) }}` function to format a list of pages with dates into a hierarchy](https://github.com/gitlayer/gitlayer/blob/master/docs/function-datetree.md)

> [`{{ filesort(...) }}` function to sort a list of files by any property](https://github.com/gitlayer/gitlayer/blob/master/docs/function-filesort.md)

> [`{{ groupmatch(...) }}` function to get a list of files matched by tags](https://github.com/gitlayer/gitlayer/blob/master/docs/function-groupmatch.md)

> [`{{ jsonfile(...) }}` function to load and parse a JSON serialised file](https://github.com/gitlayer/gitlayer/blob/master/docs/function-jsonfile.md)

> [`{{ nextpost(...) }}` function to get the next page by date](https://github.com/gitlayer/gitlayer/blob/master/docs/function-nextpost.md)

> [`{{ pathmatch(...) }}` function to get a list of files matched by URI](https://github.com/gitlayer/gitlayer/blob/master/docs/function-pathmatch.md)

> [`{{ previouspost(...) }}` function to get the previous page by date](https://github.com/gitlayer/gitlayer/blob/master/docs/function-previouspost.md)

> [`{{ tagmatch(...) }}` function to get a list of files matched by tag](https://github.com/gitlayer/gitlayer/blob/master/docs/function-tagmatch.md)

### Variable extensions

> [`{{ now }}` variable to get the current time and date](https://github.com/gitlayer/gitlayer/blob/master/docs/variable-now.md)

> [`{{ utcnow }}` variable to get the current time and date in UTC](https://github.com/gitlayer/gitlayer/blob/master/docs/variable-utcnow.md)
