# GitLayer File objects

Whenever you see a refernce to 'file object' or a 'post object' or a 'list of file
objects'  in this documentation it simply refers to a static object which has a set
number of properties that you can use in your templates. For example, to access
the current pages mime type and final URI in a Jinja2 template you can use:

```html
<p>This page is at the URI {{ this.uri }} and has the mime type {{ this.mime }}</p>
```

Which will render as...

```html
<p>This page is at the URI /my-page.html and has the mime type text/html</p>
```

That's it! Here is a complete reference to all file object properties:

| Property    | Description                                                        |
| ----------- | ------------------------------------------------------------------ |
| file        | The file name, such as `my-page.html`                              |
| dir         | The directory name the file is in, such as `/` or `/mydir/`        |
| uri         | The complete URI to the file, such as `/mydir/my-page.html`        |
| name        | The bare file name, such as just `my-page`                         |
| nameparts   | A list if the files name split by hyphens, as `['my', page']`      |
| ext         | The file extension, such as `html`                                 |
| groups      | A list of groups set for this file                                 |
| tags        | A list of tags set for this file                                   |
| size        | The file size in bytes, such as `458923`                           |
| large       | Boolean (true or false), set to true if the file is too large      |
| mime        | The mime type of the file, such as `text/html`                     |
| parent      | The parent file object if set by the `{% parent ... %}` statement  |
| parnets     | An iterable of all the parents back to a page with no parent set   |
| is_error401 | Set to true if the file is the HTTP error 401 page (401error.html) |
| is_error404 | Set to true if the file is the HTTP error 404 page (404error.html) |
| is_alias    | Set to true for aliases, such as `/` is an alias of `/index.html`  |
| is_base     | Set to true if a template and starts with a `_` (a base template)  |
| locale      | The pages locale, can be an empty string by default                |
| timezone    | The pages timezone, by default the local machines timezone         |
| date        | The pages date as a `datetime()` object                            |
| utcdate     | The pages date in UTC as a `datetime()` object                     |
| blocks      | A 'blocks' object of the content of the file, see below            |

There are a few others, but you don't need to worry about them or use them (and they
are of no use to site builders).

The `blocks` property is anothers sub-object. These are content blocks from Jinja2.
The `blocks` property simply has the content of a pages template block in it. For
example in a template:

```html
{% block test %}
Content in block test
{% endblock %}

{% block main %}
<p>The block test has the following content</p>
<!--
    this puts
        Content in block test
    into the <p></p>
-->
<p>{{ this.blocks.test %}</p>
{% endblock %}
```

Obviously, this is only useful for referencing blocks in other pages and not the
same page.

**Note** `block` properties on files do NOT support cyclic references. This means
that things like the following will return a blank string:

```html
{% block test %}
The URI of the index page is: {{ byuri('/').uri }}!
{% endblock %}

{% block main %}
<p>The block test has the following content</p>
<!--
    this puts
        The URI of the index page is: !
    into the <p></p> no sub-properties are rendered!
-->
<p>{{ this.blocks.test %}</p>
{% endblock %}
```
