# Template function: jsonfile

The `jsonfile()` function takes a path to a file containing JSON encoded data as an
argument and returns it deserialised. The path is from your website root and you
cannot load files outside of your website root / directory.

For example if `/path/to/your/website/afile.json` contained the following:

```json
[{"name":"steve"},{"name":"mark"}]
```

You can do this in your template:

```html
{% with people = jsonfile('afile.json') %}
<ul>
{% for person in people %}
    <li>{{ person.name }}</li>
{% endfor %}
</ul>
{% endwith %}
```

**Note** The maximum file size allowed is 1 megabyte.