# -*- coding: utf-8 -*-

import locale

class LocaleManager(object):
    '''
        Stores and switches locales on demand.
    '''

    default_locale = '.'.join([str(l) for l in locale.getdefaultlocale() if l])

    def __init__(self):
        self.current_locale = self.default_locale

    def switch(self, localestr):
        localestr = str(localestr)
        if not localestr:
            return False
        try:
            locale.setlocale(locale.LC_ALL, localestr)
            self.current_locale = localestr
            return True
        except (TypeError, locale.Error) as e:
            estr = 'unable to set locale (is it available locally?): {} ({})'
            _log.error(estr.format(localestr, e))

    def restore(self):
        if self.default_locale and self.current_locale != self.default_locale:
            locale.setlocale(locale.LC_ALL, self.default_locale)

localeman = LocaleManager()

# eof
