# -*- coding: utf-8 -*-

import os
import sys
from os.path import join as pjoin
from setuptools import setup, find_packages
from distutils.sysconfig import get_python_lib
from gitlayer import __version__ as version

def fread(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

setup(
    name='GitLayer',
    version=str(version),
    url='https://github.com/gitlayer/gitlayer',
    download_url='https://github.com/gitlayer/gitlayer/tarball/{}'.format(version),
    author='GitLayer development team',
    author_email='hi@GitLayer.com',
    description=('GitLayer rendering tools and development server.'),
    license='BSD',
    packages=find_packages(exclude=('gitlayer.bin',)),
    include_package_data=True,
    scripts=(pjoin('gitlayer', 'bin', 'gitlayer'),),
    entry_points={'console_scripts': ('gitlayer = gitlayer.cli:run',)},
    install_requires = ('csscompressor',
                        'jinja2',
                        'markdown',
                        'pyaml',
                        'pyScss',
                        'python-dateutil',
                        'pytz',
                        'slimit'),
    long_description=fread('README.rst'),
    zip_safe=False,
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Software Development :: Libraries :: Application Frameworks',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
    keywords = ['gitlayer',],
    test_suite = 'tests.get_tests',
)

# eof
