# Template function: byuri

The `byuri()` function returns a single file object that matches the supplied URI. It
can return false, which you must account for. As an example in a template:

```html
<p>Details about the file at <strong>/page.html</strong></p>
<ul>
{% with f = byuri('/page.html') %}
    {% if f %}
        <ul>
            <li>Mime type: {{ f.mime }}</li>
            <li>Size: {{ f.size }}</li>
            <li>Tags:
                <ul>
                {% for tag in f.tags %}
                    <li>{{ tag }}</li>
                {% endfor %}
                </ul>
            </li>
        </ul>
    {% else %}
        <p><strong>Error! No file at /page.html exists!</strong></p>
    {% endif %}
{% endwidth %}
```
