# Template function: datetree

The `datetree()` function takes a list of posts (pages with dates) and returns it in
a dictionary by year, month and day. This is meant to allow you to build a post
calendar, display posts by month or by year or other date based displaying of files.
As an example in a template:

```html
<p>All posts in a big tree</p>
<ul>
{% for year, months in datetree().items() %}
    <li>{{ year }}
    <ul>
    {% for month, days in months.items() %}
        <li>{{ month }}
        <ul>
        {% for day, posts in days.items() %}
            <li>{{ day }}
            <ul>
            {% for post in posts %}
                <li>{{ post.name }} on {{ post.date }}</li>
            {% endfor %}
            </ul>
        {% endfor %}
        </ul>
    {% endfor %}
    </ul>
{% endfor %}
</ul>
```

The `datetree()` function defaults to all posts (all pages with a date set). You can
pass it a smaller list of posts if required, such as:

```html
{% for year, months in datetree(tagmatch(['hot', 'cool'])).items() %}
    ...
{% endfor %}
```
