# Template metadata statement: locale

The `locale` template tag allows you to set a locale for any page on a per-page
basis. For example in a template:

```html
{% locale 'en_GB.UTF-8' %}
```

By default this is set by your local computer and should not need changing. This
tag is only useful for changing the output of the date filter and other
automatically generated words. This means that if you set the locale to
`es_ES.UTF-8` then `{{ file.date|dateformat('%A') }}` would return 'lunes' (Spanish
for Monday) not 'Monday', assuming that `file.date` was on a Monday.

**Note** you MUST have the locale available on your local system for this to work!
You almost certainly do not need to use this tag unless you have sub-pages on your
site which MUST be in a different language.

**Note** this statement returns nothing (an empty string) to the template.
