# Template function: filesort

The `filesort()` function takes a list of files and sorts it by the URI by default.
You can supply an extra argument which is the name of an attribute of a file to sort
by. For example in a template:

```html
<p>All posts in date order (the default)</p>
<ul>
{% for post in posts %}
    <li>{{ post.name }} on {{ post.date }}</li>
{% endfor %}
</ul>

<p>All posts sorted by <strong>URI name</strong></p>
<ul>
{% for post in filesort(posts, 'uri') %}
    <li>{{ post.name }} on {{ post.date }}</li>
{% endfor %}
</ul>

<p>All posts sorted by <strong>file size</strong></p>
<ul>
{% for post in filesort(posts, 'size') %}
    <li>{{ post.name }} on {{ post.date }}</li>
{% endfor %}
</ul>
```
