# Template function: tagmatch

The `tagmatch()` function returns a list of files that can be looped over that match
a list of tags. You can use a string or a list of tagmatch. Files are ordered by
URI by default. As an example in a template:

```html
<p>All files that match the tag <strong>hot</strong> or <strong>cool</strong></p>
<ul>
{% for f in tagmatch(['hot', 'cool']) %}
    <li>File: {{ f.name }}</li>
{% endfor %}
</ul>
```

**Note** this is identical to `groupgmatch()`, just for tags.
