# Template metadata statement: parent

The `parent` template tag allows you to set a parent page for any page on a per-page
basis. For example in a template:

```html
{% parent '/another-page.html' %}
```

This chaining of pages creates a path from each page back through all its parent
pages. You can use this to access the parent or index page for a group of pages
trivially or you can even use this to create 'breadcrubs'. You can also combine this
with remapped URIs and markdown pages. For example:

In template `c.html`:
```html
{% parent '/b.html' %}
<ul>
{% for p in this.parents|reverse %}
    <li><a href="{{ p.uri }}">{{ p.name }}</a></li>
{% endfor %}
    <li><a href="{{ this.uri }}">{{ this.name }}</a></li>
</ul>
```

In template `b.md`:
```html
---
uri: /b.html
parent: /a.html
---
```

In template `a.html`:
```html
{% parent '/' %}
```

This will generate a breadcrumb of all parent pages leading to the final page:

```html
<ul>
    <li><a href="/index.html">index</a></li>
    <li><a href="/a.html">a</a></li>
    <li><a href="/b.html">b</a></li>
    <li><a href="/c.html">c</a></li>
</ul>
```

**Note** the current page is not included in `{{ this.parents }}` which is why it is
added manually in the example above.
