# -*- coding: utf-8 -*-

import logging

console_handler = logging.StreamHandler()
console_handler.setLevel(logging.INFO)
console_formatter = logging.Formatter('%(levelname)s | %(message)s')
console_handler.setFormatter(console_formatter)
log = logging.getLogger('GitLayer')
log.setLevel(logging.INFO)
log.addHandler(console_handler)

def store_error(err):
    if err not in log.all_errors:
        log.all_errors.append(err)
    log.orig_error(err)

log.orig_error = log.error
log.error = store_error
log.all_errors = []

__version__ = 0.21
__all__ = ('build', 'cli', 'errors', 'fileindex', 'fileobj', 'handler', 'helpers',
           'jinjaext', 'locales', 'server')

# eof
