# Template metadata block: tags / endtags

The `tags` template block allows you to assign metadata to templates. Tags are
any string seperated by a comma. They can be spread over multiple lines. Example use
in a template:

```html
{% tags %}a tag, another tag, hg{% endtags %}
```

or

```html
{% tags %}
a tag,
another tag,
hg
{% endtags %}
```

**Note** the syntax and use of `{% tags %}...{% endtags %}` is idental to the use of
`{% groups %}...{% end groups %}`. We have added both groups and tags so you can
properly define your sites files. For example, you can tag pages as 'blog' then give
them the tag 'announcement'. How you classify pages with groups and tags is entirely
up to you.

**Note** this block returns nothing (an empty string) to the template.
