# -*- coding: utf-8 -*-

'''
    This whole importing tree and dynamic import helpers may look a bit weird and /
    or unnecessary but it's designed to give new users the most possible feedback to
    why the development server won't start and let users know what modules they have
    to install.
'''

import sys
import warnings

to_import = {
    # module name {
    #   import name {
    #       item {
    #           (as, ignore) }}}
    'python-dateutil': {
        'dateutil.parser': {
            'parse': 'dateparser',
        },
    },
    'pytz': {
        'pytz': None,
        'pytz.exceptions': {
            'UnknownTimeZoneError': None,
        },
    },
    'jinja2': {
        'jinja2': {
            'FileSystemLoader': None,
            'TemplateSyntaxError': None,
            'UndefinedError': None,
            'nodes': 'jinjanodes',
        },
        'jinja2.sandbox': {
            'SandboxedEnvironment': None,
            'SecurityError': None,

        },
        'jinja2.ext': {
            'Extension': 'JinjaExtension',
            'with_': 'jinjaextwith',
            'autoescape': 'jinjaextautoescape',
        },
        'jinja2.exceptions': {
            'UndefinedError': None,
        },
    },
    'markdown': {
        'markdown': {
            'markdown': None,
        },
    },
    'pyScss': {
        'scss': {
            'Scss': ('ScssParser', RuntimeWarning),
        },
    },
    'csscompressor': {
        'csscompressor': {
            'compress': 'csscompress',
        },
    },
    'slimit': {
        'slimit': {
            'minify': 'jscompress',
        },
    },
    'pyyaml': {
        'yaml': None,
    },
}

def dynamic_import(module_name, item_name=None):
    item_list = [item_name] if item_name else []
    try:
        imp = __import__(module_name, globals(), locals(), item_list, 0)
        return getattr(imp, item_name) if item_name else imp
    except ImportError as e:
        reqmods = ' '.join(sorted(to_import.keys()))
        sys.stdout.write('failed to import: {} ({})\r\n'.format(module_name, e))
        sys.stdout.write('GitLayer requires some additional Python modules, ')
        sys.stdout.write(' install them with:\r\n')
        sys.stdout.write('$ pip install --upgrade {}\r\n\r\n'.format(reqmods))
        sys.exit(2)

for pip_name, module_dict in to_import.items():
    for module_name, module_items in module_dict.items():
        if not module_items:
            locals()[module_name] = dynamic_import(module_name)
        else:
            for item_name, as_name in module_items.items():
                as_name = item_name if not as_name else as_name
                if type(as_name) == tuple:
                    as_name, ignore_type = as_name
                    with warnings.catch_warnings():
                        warnings.simplefilter('ignore', ignore_type)
                        locals()[as_name] = dynamic_import(module_name, item_name)
                else:
                    locals()[as_name] = dynamic_import(module_name, item_name)

# eof
