"""
Gmail-Notify
==========

Gmail-Notify is a coller looking GMail notifier for your favorite OS.
"""

from distutils.core import setup
from gmailnotify import __version__

setup(

    # Required metadata
    name='Gmail-Notify',
    version=__version__,

    # Scripts
    scripts = ['bin/gmail-notify'],
    # package information
    packages = [
        'gmailnotify'
    ],

    package_dir = {
        'gmailnotify': 'gmailnotify',
    },

    package_data = {
        'gmailnotify': [
            'images/*',
            'ui/gmail-notify-prefs/*'
        ],
    },

    # Additional pypi metadata
    description = 'Cooler looking GMail notifier.',

    long_description = __doc__,

    url = 'http://www.soundc.de/gmail-notifier/',

    author='Uday K Verma',
    author_email='uday.karan@gmail.com',

    classifiers=[
        'Development Status :: 4 - Beta',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Programming Language :: Python',
        'Topic :: Internet',
        'Topic :: Utilities',
        'Topic :: Communications',
        'Topic :: Communications :: Email'
    ]
)
