#    GMail-Notifier - A cooler looking gmail notifier for Ubuntu
#    Copyright (C) 2009 Uday K Verma
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gobject
import gmailnotify.atomreader as atomreader
    
class MailChecker(gobject.GObject):
    __gsignals__ = {
        'new-messages' : (gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, (gobject.TYPE_PYOBJECT,)),
        'failed-messages' : (gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, ())
    }
    
    def __init__(self, username, password):
        gobject.GObject.__init__(self)
        self.account = atomreader.GMailAtomReader (username, password)
        
    def checkMail (self):
        try:
            mails = self.account.fetchMails ()
            self.emit ('new-messages', mails)
        except Exception, e:
            self.emit ('failed-messages')
