#    GMail-Notifier - A cooler looking gmail notifier for Ubuntu
#    Copyright (C) 2009 Uday K Verma
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gconf
import gnomekeyring as gkey

def has_configuration():
    client = gconf.client_get_default()
    return client.dir_exists ("/apps/gmail-notify")
    
def setup_default_configuration():
    client = gconf.client_get_default ()
    client.add_dir ("/apps/gmail-notify", gconf.CLIENT_PRELOAD_NONE)
    
    set_config ("disable-notifications", "0")
    set_config ("username", "")
    set_config ("refresh-interval", "60000")
    set_config ("message-display-interval", "5000")
    
def set_config (key, value):
    client = gconf.client_get_default ()
    client.set_string ("/apps/gmail-notify/%s" % key, value)

def get_config (key):
    client = gconf.client_get_default ()
    return client.get_string ("/apps/gmail-notify/%s" % key)
    
def get_password (username):
    try:
        attrs = { "app" : "gmail-notify", "username" : username }
        items = gkey.find_items_sync (gkey.ITEM_NETWORK_PASSWORD, attrs)
        if len(items):
            return items [0].secret
        return ""
    except Exception, e:
        return ""

def set_password (username, password):
    kr = gkey.get_default_keyring_sync ()
    attrs = { "app" : "gmail-notify", "username" : username }
    gkey.item_create_sync (kr, gkey.ITEM_NETWORK_PASSWORD, "gmail-notify", attrs,
                           password, True)
    
if __name__ == "__main__":
    gobject.set_application_name ("Gmail-Notify-Config-Tests")
    set_password ("testuser", "testpass")
    print get_password ("testuser")
    
