#!/usr/bin/env python
#    GMail-Notifier - A cooler looking gmail notifier for Ubuntu
#    Copyright (C) 2009 Uday K Verma
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import logging
import gmailnotify
import gobject, gtk

from gmailnotify import mailchecker
from gmailnotify import statusiconmanager
from gmailnotify import notificationmanager
from gmailnotify import config
from gmailnotify import prefs
from gmailnotify import launcher

def main():
    gobject.set_application_name ("Gmail-Notify")
    
    sm = statusiconmanager.StatusIconManager ()
    nm = notificationmanager.NotificationManager ()
    mc = mailchecker.MailChecker (config.get_config("username"),
                                  config.get_password (config.get_config ("username")))
    
    def new_mail_callback (sender, messages):
        sm.updateForMessages (messages)
        nm.notifyMessages (messages)
        
    def failed_mail_callback (sender):
        sm.updateForFailed ()
        nm.updateForFailed ()
        
    def refresh_callback (sender):
        nm.clearCache ()
        mc.checkMail ()
        
    def quit_callback (sender):
        nm.close ()
        gtk.main_quit ()
        
    def mail_checker():
        mc.checkMail ()
        return True
    
    def on_creds_saved (sender):
        global mc, nm
        mc = mailchecker.MailChecker (config.get_config("username"),
                                  config.get_password (config.get_config ("username")))
        mc.connect ('new-messages', new_mail_callback)
        mc.connect ('failed-messages', failed_mail_callback)
        
        nm.stop ()
    
    def prefs_callback (sender):
        p = prefs.PrefWindow ()
        p.connect ('credentials-saved', on_creds_saved)
    
    def notification_toggle_callback(sender, enabled):
        if enabled:
            config.set_config ("disable-notifications", "1")
        else:
            config.set_config ("disable-notifications", "0")
        
    def inbox_callback (sender):
        launcher.browser ("http://gmail.google.com/mail")
        
    def mail_callback (sender, link):
        launcher.browser (link)
        
    def activate_callback (sender):
        global nm
        nm.stop ()

    # connect all mail checker notifications
    mc.connect ('new-messages', new_mail_callback)
    mc.connect ('failed-messages', failed_mail_callback)
    
    # connect all status icon manager notifications
    sm.connect ('request-refresh', refresh_callback)
    sm.connect ('request-quit', quit_callback)
    sm.connect ('request-notification-disable', notification_toggle_callback)
    sm.connect ('request-prefs', prefs_callback)
    sm.connect ('request-inbox', inbox_callback)
    sm.connect ('request-mail', mail_callback)
    sm.connect ('request-activate', activate_callback)
    
    if not config.has_configuration ():
        config.setup_default_configuration ()
        prefs_callback (None)
    
    # check mail once before starting up
    mail_checker ()
    
    gobject.timeout_add (int(config.get_config('refresh-interval')), mail_checker)
    
    try:
        gtk.main()
    except KeyboardInterrupt:
        logging.debug("Quitting application")
        sys.exit(1)
