#    GMail-Notifier - A cooler looking gmail notifier for Ubuntu
#    Copyright (C) 2009 Uday K Verma
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import gobject
import gtk.glade

import gmailnotify.config as config
import gmailnotify.atomreader as atomereader
import gmailnotify.p as path

class PrefWindow(gobject.GObject):
    __gsignals__ = { 'credentials-saved' : (gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, ()) }
    def __init__(self):
        gobject.GObject.__init__(self)
        self.wTree = gtk.glade.XML (os.path.join(path.media_path(), "ui/gmail-notify-prefs/gmail-notify-prefs.glade"))
        
        events = { 'on_button_close_clicked' : self.on_button_close_clicked,
                   'on_button_check_creds_clicked' : self.on_button_check_creds_clicked,
                   'on_save_cred_clicked' : self.on_save_cred_clicked,
                   'on_hscale_refresh_value_changed' : self.on_hscale_refresh_value_changed,
                   'on_hscale_delay_value_changed' : self.on_hscale_delay_value_changed,
                   'on_about_clicked' : self.on_about_clicked
                   }
        
        # load and setup values
        #
        self.wTree.get_widget ("username").set_text (config.get_config ("username"))
        self.wTree.get_widget ("password").set_text (config.get_password (config.get_config ("username")))
        self.wTree.get_widget ("hscale_refresh").set_value (int(config.get_config ("refresh-interval")) * 0.001)
        self.wTree.get_widget ("hscale_delay").set_value (int(config.get_config ("message-display-interval")) * 0.001)
        
        self.wTree.signal_autoconnect (events)
        
    def on_button_close_clicked (self, sender):
        self._root_window().destroy ()
    
    def _root_window (self):
        return self.wTree.get_widget ("gmailnotifyprefs")
        
    def _get_creds(self):
        return (self.wTree.get_widget ("username").get_text(),
                self.wTree.get_widget ("password").get_text())
    
    def on_button_check_creds_clicked (self, sender):
        try:
            username, password = self._get_creds()
            if not username or not password:
                mb = gtk.MessageDialog (None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
                                        "Please specify both username and password.")
                mb.set_title ("GMail Notify")
                mb.run ()
                mb.destroy ()
                return
                
            m = atomreader.GMailAtomReader (username, password)
            m.fetchMails ()
            
            mb = gtk.MessageDialog (None, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK,
                                    "GMail credentials test was sucessful.")
            mb.set_title ("GMail Notify")
            mb.run ()
            mb.destroy()
        except Exception, e:
            mb = gtk.MessageDialog (None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
                                    "GMail credentials failed to login.  Please make sure that you are connected to the internet and that your credentials are correct.")
            mb.set_title ("GMail Notify")
            mb.run ()
            mb.destroy()
            

    def on_save_cred_clicked (self, sender):        
        username, password = self._get_creds ()
        if not username or not password:
                mb = gtk.MessageDialog (None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
                                        "Please specify both username and password.")
                mb.set_title ("GMail Notify")
                mb.run ()
                mb.destroy ()
                return

        orig_un, orig_pw = config.get_config ("username"), config.get_password (config.get_config("username"))
        if orig_un != username or orig_pw != password:
            config.set_config ("username", username)
            config.set_password (username, password)
        
            self.emit ("credentials-saved")
    
    def on_hscale_refresh_value_changed (self, sender):
        config.set_config ("refresh-interval", str(int(self.wTree.get_widget ("hscale_refresh").get_value() * 1000)))
    
    def on_hscale_delay_value_changed (self, sender):
        config.set_config ("message-display-interval", str(int(self.wTree.get_widget ("hscale_delay").get_value() * 1000)))
        
    def on_about_clicked (self, sender):
        msg = gtk.MessageDialog (parent = self._root_window(), flags=0, type=gtk.MESSAGE_INFO, buttons=gtk.BUTTONS_OK)
        msg.set_markup ('GMail-Notifier for Ubuntu\n<i>A cooler looking gmail notification application</i>\n\n(C) Copyright 2009 Uday K Verma\nAll GMail icons artwork (C) Copyright IconExpo.com\n\nVisit http://soundc.de/gmail-notifier for contact information.')
        
        
        msg.set_title ('About GMail-Notifier')
        msg.run ()
        msg.destroy ()

if __name__ == "__main__":
    PrefWindow ()
    gtk.main()
