#    GMail-Notifier - A cooler looking gmail notifier for Ubuntu
#    Copyright (C) 2009 Uday K Verma
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Sound Manager to play audio files
#

__disableAllAudio = False

try:
    import pygst
    pygst.require ('0.10')
    
    import gst
except:
    __disableAllAudio = True
    
    
def playSound (uri, volume = 1.0):
    global __disableAllAudio
    if __disableAllAudio:
        return
    
    # clamp volume to 1.0
    if volume > 1.0:
        volume = 1.0
    
    # setup pipeline
    player = gst.element_factory_make ('playbin', 'player0')
    fakesink = gst.element_factory_make ('fakesink', 'fakesink0')
    player.set_property ('video-sink', fakesink)
    player.set_property ('uri', uri)
    player.set_property ('volume', volume)
    
    # start it off
    player.set_state (gst.STATE_PLAYING)
    
if __name__ == "__main__":
    import os
    
    print 'Playing sound ...'
    playSound ('file://%s/sounds/new-mail.wav' % os.path.dirname (os.path.abspath (__file__)), 0.2)
    raw_input ('Press a key to exit ...')
    
