#    GMail-Notifier - A cooler looking gmail notifier for Ubuntu
#    Copyright (C) 2009 Uday K Verma
#    Copyright (C) 2009 Ritesh Nadhani
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gconf
import gnomekeyring as gkey

# Default configuration map, in case a config is requested and it doesn't exist
# this map will be looked up.  This eliminates the need for explicitly setting
# up a default configuration map, and also makes the program upgrade-safe
# in case we add more configurations later
#
__default_config = {
    "disable-notifications" : "0",
    "sound-notifications-enabled" : "1",
    "sound-notifications-volume" : "0.5",
    "username" : "",
    "refresh-interval" : "60000",
    "message-display-interval" : "5000"
}

__config_key = "/apps/gmail-notifier"

def has_configuration():
    # we check if we have a valid username setup, if we don't we show the
    # preferences dialog.
    return len(get_config ("username")) > 0
    
def setup_default_configuration():
    client = gconf.client_get_default ()
    client.add_dir (__config_key, gconf.CLIENT_PRELOAD_NONE)
    
    # for new installations, setup the default configuration
    for k, v in __default_config.iteritems ():
        set_config (k, v)
    
def set_config (key, value):
    client = gconf.client_get_default ()
    client.set_string ("%s/%s" % (__config_key, key), value)

def get_config (key):
    client = gconf.client_get_default ()
    val = client.get_string ("%s/%s" % (__config_key, key))
    if not val and __default_config.has_key (key):
        set_config (key, __default_config [key])
        val = client.get_string ("%s/%s" % (__config_key, key))
    
    return val
    
def get_password (username):
    try:
        attrs = { "app" : "gmail-notifier", "username" : username }
        items = gkey.find_items_sync (gkey.ITEM_NETWORK_PASSWORD, attrs)
        if len(items):
            return items [0].secret
        return ""
    except Exception, e:
        return ""

def set_password (username, password):
    kr = gkey.get_default_keyring_sync ()
    attrs = { "app" : "gmail-notifier", "username" : username }
    gkey.item_create_sync (kr, gkey.ITEM_NETWORK_PASSWORD, "gmail-notifier", attrs,
                           password, True)
    
if __name__ == "__main__":
    gobject.set_application_name ("Gmail-Notifier-Config-Tests")
    set_password ("testuser", "testpass")
    print get_password ("testuser")
    