from common import *
test_x = np.linspace(0, 2 * np.pi)

x2 = np.atleast_2d(2 + 2 * np.random.rand(n)).T
y2 = np.cos(x) + 0.1 * np.random.randn(n, 1)

gp.add(x2, y2)

pred = gp.predict(np.atleast_2d(test_x).T, what=('mean', 'mse'))
mean = np.squeeze(pred['mean'])  # There is only one output dimension.
mse = pred['mse']

plt.fill_between(test_x, mean - mse, mean + mse, color=(0.8, 0.8, 1.0))
plt.plot(test_x, pred['mean'])
plt.scatter(x, y)
plt.scatter(x2, y2)
