"""
@package graphlab
...
more contents
"""

import graphlab.connect.aws as aws

from graphlab.data_structures.graph import Graph, Vertex, Edge
from graphlab.data_structures.sarray import SArray
from graphlab.data_structures.sframe import SFrame
from graphlab.toolkits.model import Model

import graphlab.toolkits
import graphlab.toolkits.clustering as clustering
import graphlab.toolkits.graph_analytics as graph_analytics
import graphlab.toolkits.recommender as recommender

from graphlab.toolkits.recommender import matrix_factorization
from graphlab.toolkits.recommender import popularity
from graphlab.toolkits.recommender import item_means
from graphlab.toolkits.recommender import item_similarity
from graphlab.toolkits.recommender import linear_regression
from graphlab.toolkits.recommender import logistic_regression

from graphlab.toolkits.graph_analytics import connected_components
from graphlab.toolkits.graph_analytics import shortest_path
from graphlab.toolkits.graph_analytics import kcore
from graphlab.toolkits.graph_analytics import pagerank
from graphlab.toolkits.graph_analytics import graph_coloring
from graphlab.toolkits.graph_analytics import triangle_counting

from graphlab.toolkits.clustering import kmeans

## bring load functions to the top level
from graphlab.data_structures.graph import load_graph
from graphlab.data_structures.sframe import load_sframe
from graphlab.toolkits.model import load_model


# internal util 
from graphlab.connect.main import launch as _launch
from graphlab.connect.main import stop as _stop

# python egg version
__VERSION__ = '0.1.0'
version = '0.1.0'

from graphlab.util import get_newest_version
from graphlab.util import perform_version_check

from graphlab.version_info import version
from graphlab.version_info import __VERSION__

perform_version_check()
