"""
Provides utility context managers related
to executing cython functions
"""

import os


class debug_trace(object):
    """
    A context manager that suppress the cython
    stack trace in release build.
    """

    def __init__(self):
        self.show_cython_trace = '1GRAPHLAB_UNITY' in os.environ

    def __enter__(self):
        pass

    def __exit__(self, exc_type, exc_value, traceback):

        if not self.show_cython_trace and exc_type:
            raise exc_type(exc_value)
