"""
The regression toolkit contains several regression models that can be trained
and used to make new predictions. 

The GraphLab regression models accept an :class:`~graphlab.SFrame`.  The most
basic type of dataset contains a column for the response variable and one or
more columns representing predictor variables.  The GraphLab regression toolkit
includes linear and logistic regression model classes. 

The :py:class:`~graphlab.linear_regression.LinearRegressionModel` model
predicts a scalar response variable as a linear function of one or more
predictor variables. 

.. sourcecode:: python

    >>> from graphlab import linear_regression, SFrame
    >>> data = SFrame('train-medical-data.csv')
    >>> m = linear_regression.create(data, response='bloodpressure', predictors=['age', 'weight', 'height'])
    >>> test_data = SFrame('test-medical-data.csv')
    >>> predictions = m.predict(test_data)
    >>> print predictions


The :class:`~graphlab.logistic_regression.LogisticRegressionModel` predicts
a binary response variable using one or more predictor variables. The
probabilities describing the outcome of the binary variable are modeled as
a logistic function of the predictor variables.

.. sourcecode:: python

    >>> from graphlab import logistic_regression, SFrame
    >>> data = SFrame('train-admissions-data.csv')
    >>> m = logistic_regression.create(data, response='admission', predictors=['GPA', 'SAT-score', 'essay-score'])
    >>> test_data = SFrame('test-admissions-data.csv')
    >>> predictions = m.predict(test_data)
    >>> print predictions

All model objects in the :mod:`regression` module expose a common set of
methods. For example, the
:py:class:`~graphlab.linear_regression.LinearRegressionModel` exposes the
following methods:

.. currentmodule:: graphlab.linear_regression

.. autosummary::

    LinearRegressionModel.list_fields
    LinearRegressionModel.get
    LinearRegressionModel.name
    LinearRegressionModel.predict
    LinearRegressionModel.evaluate
    LinearRegressionModel.save
    LinearRegressionModel.summary
    LinearRegressionModel.training_stats

A detailed list of available models and methods are provided below.

"""

from graphlab.toolkits.regression import linear_regression
from graphlab.toolkits.regression import logistic_regression
