import os
import time


class GraphLabConfig:

    __slots__ = ['graphlab_server', 'server_addr', 'server_bin', 'log_dir', 'unity_metric',
                 'mode', 'version', 'librato_user', 'librato_token', 'mixpanel_user']

    def __init__(self, server_addr=None):
        if not server_addr:
            server_addr = 'default'
        self.server_addr = server_addr
        gl_root = os.path.abspath(os.path.join(os.path.dirname(os.path.realpath(__file__)), '..', 'graphlab'))
        if "GRAPHLAB_UNITY" in os.environ:
            self.server_bin = os.environ["GRAPHLAB_UNITY"]
        elif os.path.exists(os.path.join(gl_root, "unity_server")):
            self.server_bin = os.path.join(gl_root, "unity_server")
        if "GRAPHLAB_LOG_PATH" in os.environ:
            log_dir = os.environ["GRAPHLAB_LOG_PATH"]
        else:
            log_dir = "/tmp"

        self.log_dir = log_dir
        ts = str(int(time.time()))
        self.unity_metric = os.path.join(log_dir, 'graphlab_metric_' + str(ts) + '.log')

        # Import our unity conf file if it exists, and get the mode from it
        try:
          import graphlab_env
        except ImportError:
          self.graphlab_server = 'http://tarjan.graphlab.com:9292'
          self.mode = 'UNIT'
          self.version = '0.1.desktop'
          self.librato_user = ''
          self.librato_token = ''
          self.mixpanel_user = ''
        else:
          if graphlab_env.mode in ['UNIT', 'DEV', 'QA', 'PROD']:
            self.mode = graphlab_env.mode
          else:
            self.mode = 'PROD'

          self.version = graphlab_env.version
          self.librato_user = graphlab_env.librato_user
          self.librato_token = graphlab_env.librato_token
          self.mixpanel_user = graphlab_env.mixpanel_user
          self.graphlab_server = graphlab_env.graphlab_server

          # NOTE: Rmemeber to update slots if you are adding any config parameters to this file.

    def get_unity_log(self):
        ts = str(int(time.time()))
        return os.path.join(self.log_dir, 'graphlab_server_' + str(ts) + '.log')

DEFAULT_CONFIG = GraphLabConfig()
