#:Builtin SUM aggregator for groupby
SUM = "__builtin__sum__"

MAX = "__builtin__max__"
"""Builtin Max aggregator for groupby"""

MIN = "__builtin__min__"
"""Builtin Min aggregator for groupby"""

COUNT = "__builtin__count__"
"""Builtin Count aggregator for groupby"""

AVG = "__builtin__avg__"
"""Builtin Average aggregator for groupby (Synonym for MEAN)"""

MEAN = "__builtin__avg__"
"""Builtin Average aggregator for groupby (Synonym for AVG)"""

VAR = "__builtin__var__"
"""Builtin Variance aggregator for groupby (Synonym for VARIANCE)"""

VARIANCE = "__builtin__var__"
"""Builtin Variance aggregator for groupby (Synonym for VAR)"""

STDV = "__builtin__stdv__"
"""Builtin Standard Deviation aggregator for groupby (Synonym for STD)"""

STD = "__builtin__stdv__"
"""Builtin Standard Deviation aggregator for groupby (Synonym for STDV)"""

def QUANTILE(*args):
    """
    Builtin approximate quantile aggregator for groupby.
    Accepts as an argument, one or more of a list of quantiles to query.
    For instance:

    To extract the median

    >>> sf.groupby("user", {'rating':gl.aggregate.QUANTILE(0.5)})

    To extract a few quantiles

    >>> sf.groupby("user", {'rating':gl.aggregate.QUANTILE([0.25,0.5,0.75])})

    Or equivalently

    >>> sf.groupby("user", {'rating':gl.aggregate.QUANTILE(0.25,0.5,0.75)})

    The returned quantiles are guaranteed to have 0.5% accuracy. That is to say,
    if the requested quantile is 0.50, the resultant quantile value may be
    between 0.495 and 0.505 of the true quantile.
    """
    if len(args) == 1:
        quantiles = args[0]
    else:
        quantiles = list(args)

    if not hasattr(quantiles, '__iter__'):
        quantiles = [quantiles]
    query = ",".join([str(i) for i in quantiles])
    return "__builtin__quantile__[" + query + "]"
