"""
Models that rank items based on their popularity.
"""
import graphlab.connect as _mt
import graphlab as _graphlab
from graphlab.toolkits.recommender.recommender import RecommenderModel
from graphlab.data_structures.sframe import SFrame as _SFrame
import logging as _logging


class FactorizationModel(RecommenderModel):
    """
    A flexible model that learns a set of parameters for each
    user, for each item and for each available side feature.
    Predictions  are made by multiplying the parameters between the user and the item,
    between the user and each feature, and between the item and each feature.

    See Steffen Rendle (2010): Factorization Machines, in Proceedings
    of the 10th IEEE International Conference on Data Mining (ICDM 2010).

    NOTE: This will be *deprecated* soon. Please use
    graphlab.recommender.create instead.

    """

    def __init__(self, model_proxy):
        self.__proxy__ = model_proxy

    def _get_wrapper(self):
        def model_wrapper(model_proxy):
            return FactorizationModel(model_proxy)
        return model_wrapper

