"""
Methods for creating a model that predicts using the mean item rating.
"""

import graphlab.connect as _mt
import graphlab as _graphlab
from graphlab.toolkits.recommender.recommender import RecommenderModel
from graphlab.data_structures.sframe import SFrame as _SFrame
from pandas import DataFrame as _DataFrame
import logging


def create(dataset,
           user_column='user_id', item_column='item_id',
           target_column='target',
           user_data=None, item_data=None,
           verbose=True, plot=False,
           **method_options):
    """
    Create an :class:`~graphlab.recommender.item_means.ItemMeansModel` that uses
    each item's mean rating. These mean ratings are used when scoring (user,
    item) pairs and making recommendations, regardless of user.

    NOTE: This will be *deprecated* soon. Please use
    graphlab.recommender.create instead.

    Parameters
    ----------
    dataset : SFrame
        The dataset to use for training the model.

    user_column : string
        The column name of the dataset that corresponds to user id.

    item_column : string
        The column name of the dataset that corresponds to item id.

    target_column : string
        The model will be trained to predict this column of the data set.

    user_data : SFrame
        Side information for the users.  This SFrame must have a column named
        with the  user column name given above. It provides any amount of
        additional user-specific information.

    item_data: SFrame
        Side information for the items. This SFrame must have a column named
        with the item column name given above. It provides any amount of
        additional item-specific information.

    verbose : bool, optional
        If True, print progress updates.

    Returns
    -------
    out : ItemMeansModel
        A trained ItemMeansModel.

    Examples
    --------
    If given an :class:`~graphlab.SFrame` ``sf`` with columns ``user_id`` and
    ``item_id``, then we can create a
    :class:`~graphlab.item_means.ItemMeansModel` as follows:

    >>> from graphlab import recommender
    >>> m = recommender.item_means.create(sf, 'user_id', 'item_id')

    With this model object one can make recommendations for the unique users in ``sf``:

    >>> recs = m.recommend(sf)

    The model can be saved to disk as follows:

    >>> m.save(filename)

    For more, see the documentation for
    :class:`~graphlab.recommender.item_means.ItemMeansModel`.
    """

    _mt._get_metric_tracker().track('toolkit.recsys.item_means.create')

    logging.warning("This method will be deprecated soon. Please switch to recommender.create")

    if not isinstance(dataset, (_DataFrame, _SFrame)):
        raise TypeError('dataset input must be a pandas.DataFrame or SFrame')

    if type(dataset) != _SFrame:
        dataset = _SFrame(dataset)

    if plot is True:
        print "The plot functionality for item means is not yet implemented."
        plot = False

    m = _graphlab.recommender.create(dataset,
            user_column=user_column, item_column=item_column,
            target_column=target_column,
            user_data=user_data, item_data=item_data,
            verbose=verbose,
            method='item_means',
            **method_options)

    return m


class ItemMeansModel(RecommenderModel):
    """
    Use each item's mean rating to predict the target variable, regardless of the user.

    An instance of this model can be created using
    :func:`create(..., method='item_means') <graphlab.recommender.create>`.
    Do NOT construct the model directly.

    NOTE: This will be deprecated soon. Please use
    :func:`create(..., method='item_means') <graphlab.recommender.create>`
    instead.
    """

    def __init__(self, model_proxy):
        '''__init___(self)'''
        self.__proxy__ = model_proxy

    def _get_wrapper(self):
        def model_wrapper(model_proxy):
            return ItemMeansModel(model_proxy)
        return model_wrapper
