"""
Models that rank items based on their popularity.
"""
import graphlab.connect as _mt
import graphlab as _graphlab
from graphlab.toolkits.recommender.recommender import RecommenderModel
from graphlab.data_structures.sframe import SFrame as _SFrame
from pandas import DataFrame as _DataFrame
import logging


def create(dataset,
           user_column='user_id', item_column='item_id',
           user_data=None, item_data=None,
           verbose=True, plot=False, random_seed=0,
           **method_options):
    """
    Create a :class:`~graphlab.recommender.popularity.PopularityModel` that
    ranks items based on their overall popularity. Items are scored by the
    number of times each is seen in the training set. A trained model can be
    used to score (user, item) pairs and make recommendations.

    NOTE: This will be *deprecated* soon. Please use
    graphlab.recommender.create instead.


    Parameters
    ----------
    dataset : SFrame
        The dataset to use for training the model.

    user_column : string
        The column name of the dataset that corresponds to user id.

    item_column : string
        The column name of the dataset that corresponds to item id.

    user_data : SFrame
        Side information for the users.  This SFrame must have a column named
        with the  user column name given above. It provides any amount of
        additional user-specific information.

    item_data: SFrame
        Side information for the items. This SFrame must have a column named
        with the item column name given above. It provides any amount of
        additional item-specific information.

    verbose : bool, optional
        If True, print progress updates.

    Returns
    -------
    out : PopularityModel
        A trained model.

    Examples
    --------
    If given an :class:`~graphlab.SFrame` ``sf`` with columns ``user_id`` and
    ``item_id``, then we can create a
    :class:`~graphlab.popularity.PopularityModel` as follows:

    >>> from graphlab import recommender
    >>> m = recommender.popularity.create(sf, 'user_id', 'item_id')

    With this model object one can make recommendations for the unique users in ``sf``:

    >>> recs = m.recommend(sf)

    The model can be saved to disk as follows:

    >>> m.save(filename)

    For more, see the documentation for
    :class:`~graphlab.recommender.popularity.PopularityModel`.
    """

    _mt._get_metric_tracker().track('toolkit.recsys.popularity.create')
    logging.warning("This method will be deprecated soon. Please switch to recommender.create")

    if not isinstance(dataset, (_DataFrame, _SFrame)):
        raise TypeError('dataset input must be a pandas.DataFrame or SFrame')

    if type(dataset) != _SFrame:
        dataset = _SFrame(dataset)

    if plot is True:
        print "The plot functionality for popularity is not yet implemented."
        plot = False

    m = _graphlab.recommender.create(dataset,
            user_column=user_column, item_column=item_column,
            user_data=user_data, item_data=item_data,
            verbose=verbose,
            method='popularity',
            **method_options)

    return m


class PopularityModel(RecommenderModel):
    """
    A model that ranks an item according to its popularity. Each user's
    recommendations are the overall most popular items in the data.

    An instance of this model can be created using
    :func:`create(..., method='popularity') <graphlab.recommender.create>`.
    Do NOT construct the model directly.

    NOTE: This will be deprecated soon. Please use
    :func:`create(..., method='popularity') <graphlab.recommender.create>`
    instead.
    """

    def __init__(self, model_proxy):
        '''__init__(self)'''
        self.__proxy__ = model_proxy

    def _get_wrapper(self):
        def model_wrapper(model_proxy):
            return PopularityModel(model_proxy)
        return model_wrapper
