"""
@package graphlab
...
more contents
"""

import graphlab.connect.aws as aws

from graphlab.data_structures.sgraph import Vertex, Edge
from graphlab.data_structures.sgraph import SGraph
from graphlab.data_structures.sarray import SArray
from graphlab.data_structures.sframe import SFrame
from graphlab.data_structures.sketch import Sketch
from graphlab.toolkits.model import Model

import graphlab.aggregate
import graphlab.toolkits
import graphlab.toolkits.clustering as clustering
import graphlab.toolkits.graph_analytics as graph_analytics
import graphlab.toolkits.recommender as recommender
import graphlab.toolkits.vowpal_wabbit as vowpal_wabbit
from graphlab.toolkits import evaluation

from graphlab.toolkits.graph_analytics import connected_components
from graphlab.toolkits.graph_analytics import shortest_path
from graphlab.toolkits.graph_analytics import kcore
from graphlab.toolkits.graph_analytics import pagerank
from graphlab.toolkits.graph_analytics import graph_coloring
from graphlab.toolkits.graph_analytics import triangle_counting

from graphlab.toolkits.regression import linear_regression
from graphlab.toolkits.regression import logistic_regression

from graphlab.toolkits.clustering import kmeans

## bring load functions to the top level
from graphlab.data_structures.sgraph import load_graph
from graphlab.data_structures.sframe import load_sframe
from graphlab.toolkits.model import load_model


# internal util
from graphlab.connect.main import launch as _launch
from graphlab.connect.main import stop as _stop

# python egg version
__VERSION__ = '0.3.0'
version = '0.3.0'

from graphlab.util import get_newest_version
from graphlab.util import perform_version_check

from graphlab.version_info import version
from graphlab.version_info import __VERSION__


class DeprecationHelper(object):
    def __init__(self, new_target):
        self.new_target = new_target

    def _warn(self):
        import warnings
        import logging
        warnings.warn("Graph has been renamed to SGraph. The Graph class will be removed in the next release.", PendingDeprecationWarning)
        logging.warning("Graph has been renamed to SGraph. The Graph class will be removed in the next release.")

    def __call__(self, *args, **kwargs):
        self._warn()
        return self.new_target(*args, **kwargs)

    def __getattr__(self, attr):
        self._warn()
        return getattr(self.new_target, attr)

Graph = DeprecationHelper(SGraph)

perform_version_check()
