"""
GraphLab Create includes GraphLab Canvas, a built-in visualization platform and web app designed to compliment the GraphLab Create data science and development workflow.
GraphLab Canvas can be used an interactive, browser-based application or directly via API methods.


**Visualizing GraphLab data structures in GraphLab Canvas**

GraphLab Canvas allows you to explore interactive visuals and a table of the data in an :class:`~graphlab.SFrame`, :class:`~graphlab.SGraph` and :class:`~graphlab.SArray` in the local machine's default browser. To launch GraphLab Canvas and generate views of these data structures, simply append and execute .show() to a supported GraphLab data structure. Subsequent use of .show() will update the GraphLab Canvas session.

For example, the following code will launch GraphLab Canvas and present pre-defined views of the :class:`~graphlab.SFrame` in the browser, including drill-down views of each :class:`~graphlab.SFrame` column.

>>> import graphlab as gl
>>> sf = gl.SFrame({'id':['A','B','C','A','B','A'],'value':[1,10,20,30,40,50]})
>>> sf.show()

For detailed information on using GraphLab Canvas with GraphLab data structures, see methods below.


**Resuming Graphlab Canvas after ending browser session**

The Graphlab Canvas session is hosted by the GraphLab Create Python session. While the GraphLab Create Python session is active you can re-launch GraphLab Canvas and resume its prior state. 

>>> gl.canvas.show()


**Using Graphlab Canvas with IPython notebook**

GraphLab Canas .show() methods can be used in IPython notebook.  By default, .show() will launch GraphLab Canvas in the browser. Optionally, you can output a single GraphLab Canvas view to a  IPython Notebook cell using the gl.canvas.set_target() method. 

For example, while in an IPython notebook, the following code will set the output target and present a view of the SArray in the output cell. 

>>> gl.canvas.set_target('ipynb')
>>> sarray = sf['id']
>>> sarray.show()

In the same session, you can set the output to the browser using gl.canvas.set_target('browser').
"""

from graphlab.canvas.utils import set_target
from graphlab.canvas.utils import get_target
from graphlab.canvas.utils import show
from graphlab.canvas.utils import _show
from graphlab.canvas.utils import _get_id
from graphlab.canvas.utils import _same_object
