/** @jsx React.DOM */

define(
    'plot_boxes',
    ['react', 'd3', 'plot_box', 'common_controls', 'common_util', 'chai'],
    function(React, d3, Plot, Controls, Util, chai) {
  return {
  /**
   * Visualize the distribution of lists of numbers.
   *
   * props.data -- Prerequisites
   * @value {true} numeric A true flag to indicate that this SArray contains numerical data.
   * @value {true} vector A true flag to indicate that this SArray contains vectors.
   * @value {boolean} vector_integer_keys A flag to indicate that this SArray's vectors are indexed by integers. True for array and list. False for dict.
   * @value {true} vector_numeric_values A true flag to indicate that this SArray's vectors contain numerical values.
   *
   * props -- Rendering options
   * @value {boolean} [is_inside_svg] A flag to incidate this is a child component within an existing SVG element. False by default.
   * 
   * props.data -- Data structure needed to populate a BoxAndWhisker visualization.
   * @value {number} min The minimum value of all values in all vectors.
   * @value {number} max The maximum value of all values in all vectors.
   * @value {number} mean The average value of all non-zero values in all vectors.
   * @value {number} var The variance of all non-zero values in all vectors.
   * @value {number} std The standard deviation of all non-zero values in all vectors.
   * @value {number[]} quantile A list of values representing the quantile of all non-zero values in all vectors (including min and max values).
   * @value {(integer[]|string[])} subsketch_keys A list of vectors for which sub-sketches are available.
   * @value {{(integer|string):Object}} subsketches A list of sub-sketches
   *
   * props.data.subsketches
   * @value {number} min The minimum value of a given vector.
   *@value {number} max The maximum value of a given vector.
   * @value {number} mean The average value of all non-zero values in a given vector.
   * @value {number} var The variance of all non-zero values in a given vector.
   * @value {number} std The standard deviation of all non-zero values in a given vector.
   * @value {number[]} quantile A list of values representing the quantile of all non-zero values in a given vector (including min and max values).
   *
   * props.state -- States needed to recreate the exact view of a BoxAndWhiskerArray visualization.
   * @value {number} width Width of the visualization in pixels.
   * @value {number} height Height of the visualization in pixels.
   *
   * props.state -- Transient states such as highlighting, etc.
   **/
    BoxAndWhiskerArray: React.createClass({displayName: 'BoxAndWhiskerArray',
      mixins: [Controls.Tooltip],
      render: function() {
        // Initialize chai (hooks up should for arbitrary values)
        var should = chai.should();

        // Check existence of data
        // Should have a better way of flagging when no data has yet reached the visualization
        var hasData = (Util.tryGetProperty(this.props.data, 'quantile', null) !== null);
        var isInsideSvg = Util.tryGetProperty(this.props, 'is_inside_svg', false);
        if (!hasData) {
          return isInsideSvg ? (React.DOM.div(null)) : (React.DOM.g(null));
        }

        // Check column type
        this.props.data.should.have.property('numeric');
        this.props.data.should.have.property('vector');
        this.props.data.should.have.property('vector_integer_keys');
        this.props.data.should.have.property('vector_numeric_values');
        this.props.data.numeric.should.equal(true);
        this.props.data.vector.should.equal(true);
        this.props.data.vector_integer_keys.should.be.a('boolean');
        this.props.data.vector_numeric_values.should.equal(true);

        // Check data
        this.props.data.min.should.be.a('number');
        this.props.data.max.should.be.a('number');
        this.props.data.mean.should.be.a('number');
        this.props.data.std.should.be.a('number');
        this.props.data.var.should.be.a('number');
        this.props.data.quantile.should.have.length(101);

        this.props.data.subsketch_keys.should.be.instanceof(Array);
        this.props.data.subsketches.should.be.instanceof(Array);

        // With the fake (random) subsketch data for this visualization,
        // the keys are always numeric, so the assertion below does not hold.
        /*
        this.props.data.subsketch_keys.forEach(function(d) {
          if (this.props.data.vector_integer_keys) {
            d.should.be.an('number');
          } else {
            d.should.be.an('string');
          }
        }, this);
        */

        this.props.data.subsketches.forEach(function(d) {
          d.min.should.be.a('number');
          d.max.should.be.a('number');
          d.mean.should.be.a('number');
          d.std.should.be.a('number');
          d.var.should.be.a('number');
          d.quantile.should.have.length(101);
        }, this);

        // Get parameters
        var width = Util.tryGetProperty(this.props, 'width', 152);
        var height = Util.tryGetProperty(this.props, 'height', 100);
        var subsketchCount = this.props.data.subsketch_keys.length;
        var subsketchWidth = width;
        var subsketchSpacing = height / subsketchCount;
        var subsketchHeight = subsketchSpacing - 2;
        var style = {
          'width': width,
          'height': height
        };

        var BoxAndWhisker = Plot.BoxAndWhisker;
        var viewBody = (
          React.DOM.g( {className:"BoxAndWhiskerArray"}, 
            this.props.data.subsketches.map(function(subsketch, i) {
              return (
                React.DOM.g( {transform:"translate(0,"+(i*subsketchSpacing+1)+")"}, 
                  BoxAndWhisker( {data:subsketch, width:subsketchWidth, height:subsketchHeight, is_inside_svg:true, min_value:this.props.data.min, max_value:this.props.data.max} )
                )
              );
            }, this)          
          )
        );
        var tooltipOnMouseOver = this.tooltipMouseOver.bind(this, (
          React.DOM.table( {className:"canvas-sframe-boxplot-tooltip"}, 
            [0, 1, 2, 25, 50, 75, 98, 99, 100].map(function(q) {
              var quantile = this.props.data.quantile;
              return (
                React.DOM.tr( {key:q}, React.DOM.td(null, "quantile(",q / 100,"):"),React.DOM.td(null, Util.formatNumber(quantile[q])))
              );
            }.bind(this))
          )
        ));
        var tooltipOnMouseOut = this.tooltipMouseOut;
        return isInsideSvg ? viewBody : (
          React.DOM.div( {className:"canvas-plot-boxandwhiskerarray"}, 
            React.DOM.svg( {style:style, onMouseOver:tooltipOnMouseOver, onMouseOut:tooltipOnMouseOut}, 
              viewBody
            ),
            this.getTooltip()
          )
        );
      }
    })
  };
});
