/** @jsx React.DOM */

define('plot_frequency',
      ['react', 'd3', 'common_controls', 'common_util'],
      function(React, d3, Controls, Util) {

  return {
    Frequency: React.createClass({displayName: 'Frequency',
      mixins: [Controls.Tooltip],
      getInitialState: function() {
        return {
          'hover': null
        };
      },
      getDefaultProps: function() {
        return {
          'aspectRatio': 3,
          'maxValues': 30,
          'width': 152,
          'onItemClick': null,
          'highlightElement': null /* element to highlight, for cross filtering */
        };
      },
      onMouseOver: function(idx, value, evt) {
        this.tooltipMouseOver((
          React.DOM.span(null, 
            value.key == '' ? "''" : value.key,": ",
            Util.formatNumber(value.value), " (",Util.formatNumber((value.value/this.props.data.size)*100),"%)"
          )
        ), evt);
        this.setState({
          'hover': idx
        });
        if ('onItemHover' in this.props) {
          this.props.onItemHover(idx);
        }
      },
      onMouseOut: function(evt) {
        this.tooltipMouseOut(evt);
        this.setState({
          'hover': null
        });
        if ('onItemHover' in this.props) {
          this.props.onItemHover(null);
        }
      },
      render: function() {
        var width = this.props.aspectRatio;
        var values = [];
        if ('frequent_items' in this.props.data &&
             Object.keys(this.props.data.frequent_items).length > 0) {
          values = Util.sortFrequentItems(this.props.data.frequent_items, this.props.maxValues);
        } else {
          values = [{
            'key': '',
            'value': 0
          }];
        }
        var x = d3.scale
                  .linear()
                  .domain([0, values.length])
                  .range([0, width]);
        var y = d3.scale
                  .linear()
                  .domain([0, values[0].value])
                  .range([0, 1]);
        var barWidth = (width / values.length) - (0.01 * width);
        var viewBox = [0,0, width, 1].join(' ');
        var hover = 'hover' in this.props ? this.props.hover : this.state.hover;
        return (
          React.DOM.div(null, 
            React.DOM.svg(
              {viewBox:viewBox,
              width:this.props.width,
              height:this.props.width / this.props.aspectRatio}
            , 
              values.map(function(value, idx) {
                var opacity = this.props.highlightElement === null ||
                              this.props.highlightElement === value.key ?
                              1.0 : 0.3;
                var onClickFn = this.props.onItemClick === null ?
                              null : this.props.onItemClick.bind(null, value.key);
                return (
                  React.DOM.g( {key:idx}, 
                    React.DOM.rect(
                      {width:barWidth,
                      height:y(values[0].value),
                      x:x(idx),
                      y:1 - y(values[0].value),
                      onMouseOver:this.onMouseOver.bind(this, idx, value),
                      onMouseOut:this.onMouseOut,
                      fill:"#fff"}
                    ),
                    React.DOM.rect(
                      {fill:hover === idx ? '#ff5500' : '#0a8cc4',
                      width:barWidth,
                      height:y(value.value),
                      x:x(idx),
                      y:1 - y(value.value),
                      onMouseOver:this.onMouseOver.bind(this, idx, value),
                      onMouseOut:this.onMouseOut,
                      onClick:onClickFn,
                      style:{
                        'opacity': opacity,
                        'cursor': onClickFn === null ? 'default' : 'pointer',
                        'transition': 'opacity 0.3s ease'
                      }}
                    )
                  )
                );
              }.bind(this))
            ),
            this.getTooltip()
          )
        );
      }
    })
  };
});
