/** @jsx React.DOM */
// View for SFrame

define('sframe',
      ['react', 'plots', 'common_util', 'taskqueue', 'common_controls', 'logging', 'jquery', 'd3', 'bowser'],
      function(React, Plots, Util, TaskQueue, Controls, Logging, jQuery, d3, Bowser) {
 
  // keep in sync with _INITIAL_SKETCH_ROWS in views/sarray.py 
  var _INITIAL_SKETCH_ROWS = 10000

  var cursors = {
    'grab': Bowser.webkit ? '-webkit-grab' : 'grab',
    'grabbing': Bowser.webkit ? '-webkit-grabbing': 'grabbing'
  };

  // A single column title on SFrame (link to select column)
  var Column = React.createClass({displayName: 'Column',
    handleClick: function(evt) {
      var selected_column = this.props.selected_variable.name.concat([this.props.name]);
      this.props.selectVariable(selected_column);
    },
    render: function() {
      var getColumnName = function() {
        if (this.props.ipython) {
          return this.props.name;
        } else {
          return (
            React.DOM.a( {href:"javascript:", onClick:this.handleClick, className:"canvas-sframe-column-title"} , 
              this.props.name
            )
          );
        }
      }.bind(this);
      return (
        React.DOM.div( {className:"canvas-sframe-column-header"}, 
          getColumnName()
        )
      );
    }
  });

  // A single column on SFrame (details and summary statistics)
  var SFrameColumnView = React.createClass({displayName: 'SFrameColumnView',
    render: function() {
      var rows = Util.tryGetProperty(this.props.selected_variable, ['descriptives', 'rows'], 0);
      if (rows === 0) {
        return (
          React.DOM.div(null, 
            React.DOM.h5(null, 
              "No data in this column."
            )
          )
        );
      }
      var categorical = !Util.tryGetProperty(this.props.sketch, 'numeric', false);
      var dtype = Util.tryGetProperty(this.props.column, 'dtype');
      var summaryPlots = [];
      if (dtype === 'dict') {
        var keysSketch = Util.tryGetProperty(this.props.sketch, 'keys', {});
        var valuesSketch = Util.tryGetProperty(this.props.sketch, 'values', {});
        var valuesNumeric = Util.tryGetProperty(valuesSketch, 'numeric', false);
        var valueDescription = valuesNumeric ? 'distribution of values (all keys):' : 'frequent items (all keys):';
        summaryPlots.push(
          React.DOM.div( {key:"dict_summary"}, 
            React.DOM.div( {className:"canvas-sframe-summary-plot-title"}, "frequent keys:"),
            SummaryPlot(
              {data:keysSketch,
              categorical:!Util.tryGetProperty(keysSketch, 'numeric', false),
              maxItems:5}
            ),
            React.DOM.div( {className:"canvas-sframe-summary-plot-title"}, valueDescription),
            SummaryPlot(
              {data:valuesSketch,
              categorical:!Util.tryGetProperty(valuesSketch, 'numeric', false),
              width:36,
              vertical:true,
              maxItems:5}
            )
          )
        );
      } else {
        var description = categorical ? 'frequent items' : 'distribution of values';
        if (dtype === 'list' || dtype === 'array') {
          description += ' (all sub-columns)';
        }
        summaryPlots.push(
          React.DOM.div( {key:"nondict_summary"}, 
            React.DOM.div( {className:"canvas-sframe-summary-plot-title"}, description,":"),
            SummaryPlot(
              {data:this.props.sketch,
              categorical:categorical,
              width:36,
              vertical:true,
              maxItems:12}
            )
          )
        );
      }
      var loading = (rows > _INITIAL_SKETCH_ROWS && (!('initial' in this.props.sketch) || this.props.sketch.initial)) ||
        !('complete' in this.props.sketch) || !this.props.sketch.complete;
      var num_unique = dtype === 'dict' ?
        (SummaryStatistic( {name:"unique keys (est.)", value:Util.tryGetProperty(this.props.sketch, ['keys', 'num_unique']), loading:loading} )) :
        (SummaryStatistic( {name:"num_unique (est.)", value:this.props.sketch.num_unique, loading:loading} ));
      var additionalStats = (!categorical) ? [
        'min', 'max', 'mean', 'std'
      ].map(function(stat, idx) {
        return (SummaryStatistic( {key:idx, name:stat, value:this.props.sketch[stat], loading:false} ));
      }.bind(this)) : null;
      return (
        React.DOM.div(null, 
          React.DOM.table( {className:"canvas-sframe-inner-table"}, 
            React.DOM.tbody(null, 
              SummaryStatistic( {name:"dtype", value:dtype} ),
              num_unique,
              SummaryStatistic( {name:"num_undefined", value:this.props.sketch.num_undefined, loading:loading} ),
              additionalStats
            )
          ),
          summaryPlots
        )
      );
    }
  });

  var ColumnFrequencyPlot = React.createClass({displayName: 'ColumnFrequencyPlot',
    render: function() {
      if (!('frequent_items' in this.props.data) ||
          this.props.data.frequent_items.length === 0) {
        return (React.DOM.div(null ));
      }
      var width = 176;
      var maxItems = Util.tryGetProperty(this.props, 'maxItems', 10);
      var sorted = Util.sortFrequentItems(this.props.data.frequent_items, maxItems);
      if (sorted.length === 0) {
        return (React.DOM.div( {className:"canvas-sframe-summary-statistic-name"}, "No values appear with ≥ 0.01% occurrence."));
      }
      var scale = d3.scale.linear().domain([0, sorted[0].value]).range([0, width]); 
      return (
        React.DOM.div(null, 
          React.DOM.table(null, React.DOM.tbody(null, 
            sorted.map(function(pair, idx) {
              var label = pair.key;
              if (label === '') {
                label = "''";
              } else if (typeof label === 'number') {
                label = Util.formatNumber(label);
              }
              return (
                React.DOM.tr( {key:idx}, 
                  React.DOM.td( {style:{position: 'relative', width: width, height: 22}}, 
                    React.DOM.div( {style:{position: 'absolute', left: 0, top: 0, width: scale(pair.value), height: 20, backgroundColor: 'rgba(133, 189, 0, 0.2)'}} ),
                    React.DOM.div( {style:{paddingLeft: 8, paddingRight: 8, width: width, height: 20, overflow: 'hidden'}}, label)
                  )
                )
              );
            }.bind(this))
          ))
        )
      );
    }
  });
  
  var SummaryPlot = React.createClass({displayName: 'SummaryPlot',
    render: function() {
      var plot = this.props.categorical ?
        ColumnFrequencyPlot() :
        Plots.BoxAndWhisker();
      return (
        React.DOM.div( {className:"canvas-sframe-column-plot"}, 
          this.transferPropsTo(plot)
        )
      );
    }
  });

  var SummaryStatistic = React.createClass({displayName: 'SummaryStatistic',
    render: function() {
      var value = this.props.value;
      if (this.props.loading) {
        value = (React.DOM.span( {style:{position: 'relative', marginLeft: 30, marginRight: -10}}, React.DOM.i( {className:"fa-li fa fa-spinner fa-spin"} )));
      } else if (typeof value === 'number') {
        value = Util.formatNumber(value);
      }
      return (
        React.DOM.tr(null, 
          React.DOM.td( {className:"canvas-sframe-summary-statistic-name"}, 
            this.props.name,": "
          ),
          React.DOM.td( {className:"canvas-sframe-summary-statistic-value"}, 
            value
          )
        )
      );
    }
  });

  var SummaryView = React.createClass({displayName: 'SummaryView',
    mixins: [Controls.AsyncState],
    getInitialState: function() {
      if (this.props.ipython == true) {
        return {
          'sketch': this.props.sketch
        }
      }
      return {
        'sketch': {}
      };
    },
    getColumns: function(props) {
      return Util.tryGetProperty(props.selected_variable, 'columns', []);
    },
    updateAsyncState: function(nextProps) {
      var pageTasks = [];
      var rows = Util.tryGetProperty(nextProps.selected_variable, ['descriptives', 'rows'], 0);
      if (rows !== 0) {
        // If there are >0 rows in the SFrame,
        // then we should get the 
        // sketch_summary for each column.
        // Otherwise we need not bother.

        // get initial sketches for all columns first
        pageTasks.push(new TaskQueue.ProgressTask('/initialsketch', 'initial sketch_summary() for all columns', function(data) {
          this.setState({'sketch': data.sketches});
        }.bind(this)));

        // kick off a request for sketch_summary on each column
        if (rows > _INITIAL_SKETCH_ROWS) {
          var columns = this.getColumns(nextProps);
          for (var i=0; i<columns.length; i++) {
            var col = columns[i].name;
            pageTasks.push(
              new TaskQueue.ProgressTask('/sketch/' + col, '["' + col + '"].sketch_summary()', function(c, data) {
                var sketch = {};
                sketch[c] = data;
                this.setState({
                  'sketch': Util.merge(this.state.sketch, sketch)
                });
              }.bind(this, col), Util.getSketchPollInterval(rows))
            );
          }
        }
        this.addTask((new TaskQueue.MultiTask(pageTasks)).always(function() {
          // report metrics
          var metric = (this.canceled ? 'page_task' : 'page_task.canceled') + '.duration.ms';
          Logging.reportMetric(metric, this.elapsed(), {
            'operation': this.operation(),
            'type': 'SFrame'
          });
        }));
      }
    },
    render: function() {
      var columns = this.getColumns(this.props);
      var ipythonStyle = this.props.ipython ? {'overflow-x' : 'auto'} : {};
      return (
        React.DOM.div( {style:ipythonStyle}, 
        React.DOM.table( {className:"canvas canvas-sframe-table"}, 
          React.DOM.thead(null, 
            React.DOM.tr(null, 
              columns.map(function(column) {
                return (
                  React.DOM.th( {key:column.name, className:"padding"}, 
                    Column(
                      {selectVariable:this.props.selectVariable,
                      selected_variable:this.props.selected_variable,
                      name:column.name,
                      ipython:this.props.ipython}
                    )
                  )
                );
              }.bind(this))
            )
          ),
          React.DOM.tbody(null, 
            React.DOM.tr(null, 
              columns.map(function(column) {
                return (
                  React.DOM.td( {key:column.name, className:"padding"}, 
                    SFrameColumnView(
                      {sketch:Util.tryGetProperty(this.state.sketch, column.name, {}),
                      column:column,
                      selected_variable:this.props.selected_variable}
                    )
                  )
                );
              }.bind(this))
            )
          )
        )
        )
      );
    }
  });

  var TabularView = React.createClass({displayName: 'TabularView',
    mixins: [Controls.AsyncState, Controls.SizeToWindow],
    getDefaultProps: function() {
      return {
        // should be higher than will appear on one screen
        // we will store this many rows around the current starting row
        'rowsToFetch': 300,
        'rowHeight': 38
      };
    },
    getInitialState: function() {
      return {
        'rows': [],
        'rowStart': 0,
        'scrollTop': 0,
        'scrollLeft': 0,
        'currentTask': null,
        'taskTimeout': null,
        'pageOffset': 0,
        'pageDragOffset': 0,
        'pageDragStart': null,
        'highlightRow': null
      };
    },
    updateAsyncState: function(nextProps) {
      var pageTasks = [];
      if (Util.tryGetProperty(nextProps.selected_variable, ['descriptives', 'rows'], 0) !== 0) {
        // If there are >0 rows in the SFrame,
        // then we should get the head
        // for each column.
        // Otherwise we need not bother.
        pageTasks.push(new TaskQueue.SingleTask('/rows/' + String(this.state.rowStart) + '/' + String(this.props.rowsToFetch + this.state.rowStart), '.head()').done(function(data) {
          this.setState({
            'rows': data.values
          });
        }.bind(this)));

        this.addTask((new TaskQueue.MultiTask(pageTasks)).always(function() {
          // report metrics
          var metric = (this.canceled ? 'page_task' : 'page_task.canceled') + '.duration.ms';
          Logging.reportMetric(metric, this.elapsed(), {
            'operation': this.operation(),
            'type': 'SFrame'
          });
        }));
      }
    },
    scrollTable: function(evt) {
      var scrollTop = $(evt.target).scrollTop();
      var scrollLeft = $(evt.target).scrollLeft();
      this.setState({
        'scrollTop': scrollTop,
        'scrollLeft': scrollLeft
      });
      this.updateTable(scrollTop, this.state.pageOffset);
    },
    updateTable: function(scrollTop, pageOffset) {
      // update rows if needed
      var newDimensions = this.getDimensions(scrollTop, pageOffset);
      if ((newDimensions.currentRowStart > this.state.rowStart + this.props.rowsToFetch - 50) ||
          (Math.max(newDimensions.currentRowStart - 5, 0) < this.state.rowStart)) {
        // if we are scrolled down to only 50 rows remaining below or
        // 5 rows remaining above, fetch some more
        var newStart = Math.max(newDimensions.currentRowStart - 50, 0);
        if (newStart !== this.state.rowStart) {
          var task = new TaskQueue.SingleTask('/rows/' + String(newStart) + '/' + String(newStart + this.props.rowsToFetch)).done(function(data) {
            this.setState({
              'rows': data.values,
              'rowStart': newStart,
              'currentTask': null
            });
          }.bind(this)).fail(function() {
            this.setState({'currentTask': null});
          }.bind(this));
          // if there is a current task, cancel it
          if (this.state.taskTimeout !== null) {
            clearTimeout(this.state.taskTimeout);
          }
          if (this.state.currentTask !== null) {
            this.state.currentTask.cancel();
          }
          this.setState({
            'currentTask': task,
            'taskTimeout': setTimeout(function() {
              // wait before kicking it off
              // if the user is actively scrolling, lots of these events fire
              task.run();
            }, 200)
          });
        }
      }
    },
    getColumns: function() {
      return Util.tryGetProperty(this.props.selected_variable, 'columns', []);
    },
    getColumnWidth: function(dtype) {
      return {
        'int': 110,
        'float': 110,
        'str': 260,
        'dict': 260,
        'list': 260,
        'array': 260
      }[dtype];
    },
    getDimensions: function(scrollTop, pageOffset) {
      if (typeof scrollTop === 'undefined') {
        scrollTop = this.state.scrollTop;
      }
      if (typeof pageOffset === 'undefined') {
        pageOffset = this.state.pageOffset;
      }
      var totalRows = Util.tryGetProperty(this.props.selected_variable, ['descriptives', 'rows'], 0);
      var docScrollerThreshold = 100000;
      var docScrollerWidth = 96;
      var elementsAboveHeight = 42 + 55 + 4 + 60 + 40; // tabs, breadcrumb, color bar, view-main padding, padding
      var elementHeight = this.state.windowHeight - elementsAboveHeight;
      var columnHeaderHeight = this.props.rowHeight + 1;
      var docScrollerHeight = elementHeight - 10;
      var docScrollerPageHeight = Math.min(1, (docScrollerThreshold / totalRows)) * docScrollerHeight;
      var docScrollerVisualPadding = Math.max(0, 10 - docScrollerPageHeight); // pad the page scroller to be at least 10px tall
      var elementsLeftWidth = 230 + 60 + 30 + docScrollerWidth; // left nav w/ padding, view-main padding, padding
      var elementWidth = this.state.windowWidth - elementsLeftWidth;
      var columns = this.getColumns();

      // use the current doc scroller position to determine rows
      var rowsInView = Math.min(totalRows, docScrollerThreshold);
      var currentPageStart = Math.ceil((pageOffset / docScrollerHeight) * totalRows);
      var currentRowStart = currentPageStart + Math.floor(scrollTop / this.props.rowHeight);
      currentRowStart -= currentRowStart % 2; // start on even row
      var rowsVisible = Math.ceil(elementHeight / this.props.rowHeight) + 3;
      var currentRowEnd = currentRowStart + rowsVisible;
      var fillerAbove = Math.min(rowsVisible, this.state.rowStart - currentRowStart);
      var fillerBelow = Math.min(rowsVisible, currentRowEnd - (this.state.rowStart + this.props.rowsToFetch));
      var heightAbove = (currentRowStart - currentPageStart) * this.props.rowHeight;
      var heightBelow = Math.max(0, (rowsInView - (currentRowEnd - currentPageStart)) * this.props.rowHeight);
      var rowHeaderWidth = 18 + Math.floor(10 * Math.log(totalRows) / Math.LN10);
      var tableWidth = Math.min(elementWidth, columns.reduce(function(prev, col) {return prev + this.getColumnWidth(col.dtype);}.bind(this), rowHeaderWidth + 1));
      return {
        elementHeight: elementHeight,
        currentRowStart: currentRowStart,
        currentRowEnd: currentRowEnd,
        fillerAbove: fillerAbove,
        fillerBelow: fillerBelow,
        heightAbove: heightAbove,
        heightBelow: heightBelow,
        rowHeaderWidth: rowHeaderWidth,
        tableWidth: tableWidth,
        docScrollerWidth: docScrollerWidth,
        docScrollerHeight: docScrollerHeight,
        docScrollerPageHeight: docScrollerPageHeight,
        docScrollerVisualPadding: docScrollerVisualPadding,
        rowsInView: rowsInView,
        columnHeaderHeight: columnHeaderHeight,
        totalRows: totalRows,
        docScrollerThreshold: docScrollerThreshold
      };
    },
    highlightRow: function(idx) {
      if (idx === this.state.highlightRow) {
        // toggle off
        idx = null;
      }
      this.setState({'highlightRow': idx});
    },
    render: function() {
      var dimensions = this.getDimensions();
      var columns = this.getColumns();
      var getCellStyle = function(w) {
        return {
          'overflow': 'hidden',
          'width': w,
          'minWidth': w,
          'maxWidth': w,
          'height': this.props.rowHeight - 2 /* border */,
          'minHeight': this.props.rowHeight - 2 /* border */,
          'maxHeight': this.props.rowHeight - 2 /* border */
        };
      }.bind(this);
      var getCellContentStyle = function(w) {
        return Util.objectMap(getCellStyle(w), function(name, value) {
          var ret = {};
          ret[name] = typeof value === 'number' ? value - 16 /* td padding from bootstrap */ : value;
          return ret;
        });
      };
      var getRowHTML = function(i, row) {
        var rowStyle = this.state.highlightRow === i ? {
          'backgroundColor': 'rgba(255, 85, 0, 0.2)'
        } : {};
        return (
          React.DOM.tr( {key:i, className:"canvas-sframe-table-head-row", onClick:this.highlightRow.bind(this, i)}, 
            React.DOM.th( {style:Util.merge(getCellStyle(dimensions.rowHeaderWidth), rowStyle)}, 
              React.DOM.div( {style:Util.merge(getCellContentStyle(dimensions.rowHeaderWidth), {color: '#85bd00', fontWeight: 300})}, 
                Util.formatNumber(i)
              )
            ),
            row == null ? (
              React.DOM.td( {className:"padding canvas-sframe-table-head-value", style:Util.merge(getCellStyle(this.getColumnWidth(columns[0].dtype)), rowStyle), colSpan:columns.length}, 
                React.DOM.div( {style:{'position': 'relative', 'marginLeft': this.props.rowHeight}}, React.DOM.i( {className:"fa-li fa fa-spinner fa-spin"} ))
              )
            ) : row.map(function(value, j) {
              if (value === '') {
                value = "''";
              }
              else if (typeof value === 'number') {
                value = Util.formatNumber(value)
              }
              return (
                React.DOM.td( {key:j, className:"padding canvas-sframe-table-head-value", style:Util.merge(getCellStyle(this.getColumnWidth(columns[j].dtype)), rowStyle)}, 
                  React.DOM.div( {style:getCellContentStyle(this.getColumnWidth(columns[j].dtype))}, 
                    value
                  )
                )
              );
            }.bind(this))
          )
        );
      }.bind(this);
      var goToRowChange = function(evt) {
        var value = null;
        try {
          value = parseInt($('#goToRow').val(), 10 /*base*/);
        } catch (e) {
          return;
        }
        var dimensions = this.getDimensions();
        var pageOffset = (value / dimensions.totalRows) * dimensions.docScrollerHeight;
        var maxValueForPageOffset = dimensions.totalRows - dimensions.rowsInView;
        var scrollOffset = 0;
        if (value < 0) {
          value = 0;
        }
        if (value > dimensions.totalRows - 1) {
          value = dimensions.totalRows - 1;
        }
        if (value > maxValueForPageOffset) {
          var scrollForward = value - maxValueForPageOffset;
          pageOffset = (maxValueForPageOffset / dimensions.totalRows) * dimensions.docScrollerHeight;
          scrollOffset = (scrollForward / dimensions.rowsInView) * (dimensions.rowsInView * this.props.rowHeight);
        }
        this.setState({
          pageOffset: pageOffset,
          pageDragOffset: pageOffset
        });
        $('#tableArea').scrollTop(scrollOffset);
        this.updateTable(scrollOffset, pageOffset);
      }.bind(this);
      var goToRowHeight = 20;
      var goToRowGreyBorder = '1px solid #dedede';
      var goToRow = (
        React.DOM.div( {style:{
            width: dimensions.docScrollerWidth,
            height: goToRowHeight
          }}, 
          React.DOM.input( {id:"goToRow", style:{width: 69, height: goToRowHeight, borderLeft: goToRowGreyBorder, borderTop: goToRowGreyBorder, borderBottom: goToRowGreyBorder, borderRight: 'none', paddingLeft: 5}, type:"number", placeholder:"row #"}),
          React.DOM.a( {style:{display: 'inline-block', width: 27, height: goToRowHeight, backgroundColor: '#85bd41', color: 'white', textTransform: 'uppercase', verticalAlign: 'top', textDecoration: 'none', lineHeight: String(goToRowHeight) + 'px', textAlign: 'center', fontSize: 11}, href:"javascript:", onClick:goToRowChange}, 
            "Go"
          )
        )
      );
      var docScrollerDragStart = function(evt) {
        evt.preventDefault();
        evt.stopPropagation();
        this.setState({pageDragStart: evt.clientY});
      }.bind(this);
      var _docScrollerDrag = function(evt) {
        if (this.state.pageDragStart === null) {
          return null;
        }
        var diff = evt.clientY - this.state.pageDragStart;
        var dimensions = this.getDimensions();
        var newOffset = Math.min(dimensions.docScrollerHeight - dimensions.docScrollerPageHeight, Math.max(0, this.state.pageOffset + diff));
        return newOffset;
      }.bind(this);
      var docScrollerDrag = function(evt) {
        if (this.state.pageDragStart !== null) {
          evt.preventDefault();
          evt.stopPropagation();
          this.setState({pageDragOffset: _docScrollerDrag(evt)});
        }
      }.bind(this);
      var docScrollerDragEnd = function(evt) {
        evt.preventDefault();
        evt.stopPropagation();
        if (this.state.pageDragStart !== null) {
          var newOffset = _docScrollerDrag(evt);
          this.setState({pageDragStart: null, pageOffset: newOffset, pageDragOffset: newOffset});
          this.updateTable(this.state.scrollTop, newOffset);
        }
      }.bind(this);
      var docScrollerClick = function(evt) {
        if (this.state.pageDragStart === null) {
          evt.preventDefault();
          evt.stopPropagation();
          var dimensions = this.getDimensions();
          var offset = Math.max(0, (evt.clientY - $(evt.currentTarget).offset().top) - (dimensions.docScrollerPageHeight / 2));
          var newOffset = Math.min(dimensions.docScrollerHeight - dimensions.docScrollerPageHeight, offset);
          this.setState({pageOffset: offset, pageDragOffset: newOffset});
          this.updateTable(this.state.scrollTop, newOffset);
        } else {
          docScrollerDragEnd(evt);
        }
      }.bind(this);
      var docScrollerPoints = [
        [0, this.state.pageDragOffset],
        [0, this.state.pageDragOffset + dimensions.docScrollerPageHeight + dimensions.docScrollerVisualPadding],
        [50, dimensions.elementHeight + dimensions.columnHeaderHeight + dimensions.docScrollerVisualPadding - goToRowHeight - 18],
        [50, dimensions.columnHeaderHeight - goToRowHeight - 18]
      ];
      var notScrollable = dimensions.totalRows <= dimensions.docScrollerThreshold;
      var docScrollerRectColor = notScrollable ? '#dfe0e1' : '#85bd00';
      var docScroller = dimensions.docScrollerWidth == 0 ? null : (
        React.DOM.div( {style:{ width: dimensions.docScrollerWidth }} , 
          React.DOM.div( {style:{ paddingTop: 5 }, className:"canvas-docscroller-label"}, "0"),
          React.DOM.svg( {style:{ width: 10, height: dimensions.docScrollerHeight}}, 
            d3.range(10).map(function(i) {
              var y = (i / 9) * dimensions.docScrollerHeight;
              return (React.DOM.line( {key:i, x1:4, x2:10, y1:y, y2:y, stroke:"#dfe0e1", strokeWidth:2} ));
            }.bind(this))
          ),
          React.DOM.div(
            {style:{
              width: 36,
              height: dimensions.docScrollerHeight + dimensions.docScrollerVisualPadding,
              display: 'inline-block',
              cursor: (notScrollable ? 'auto' : 'pointer'),
              position: 'relative'
            },
            onMouseMove:docScrollerDrag,
            onMouseLeave:docScrollerDragEnd,
            onClick:docScrollerClick}
          , 
            React.DOM.svg( {style:{ position: 'absolute', top: 0, left: 0, width: 36, height: dimensions.docScrollerHeight}}, 
              React.DOM.rect( {x:0, y:this.state.pageDragOffset, width:36, height:dimensions.docScrollerPageHeight + dimensions.docScrollerVisualPadding, fill:'#d9e3cd', style:{'opacity': notScrollable ? 0 : 1}} ),
              d3.range(dimensions.docScrollerHeight / 5).map(function(y) {
                return d3.range(5).map(function(x) {
                  var fill = '#dfe0e1';
                  if (y * 5 >= this.state.pageDragOffset &&
                     (y * 5) + 4 <= this.state.pageDragOffset + dimensions.docScrollerPageHeight) {
                    fill = docScrollerRectColor;
                  }
                  return (
                    React.DOM.rect( {key:String(x) + '_' + String(y), x:6 + (x * 5), y:y * 5, width:4, height:4, fill:fill} )
                  );
                }.bind(this));
              }.bind(this))
            ),
            React.DOM.div(
              {style:{
                position: 'absolute',
                top: this.state.pageDragOffset,
                left: 0,
                width: 36,
                height: dimensions.docScrollerPageHeight + dimensions.docScrollerVisualPadding,
                cursor: notScrollable ? 'auto' : (this.state.pageDragStart !== null ? cursors.grabbing : cursors.grab)
              },
              onMouseDown:docScrollerDragStart}
            ) 
          ),
          React.DOM.svg( {style:{ width: 50, height: dimensions.docScrollerHeight + dimensions.docScrollerVisualPadding + 10, display: 'inline-block', verticalAlign: 'top', opacity: notScrollable ? 0 : 1 }}, 
            React.DOM.linearGradient( {id:"docScrollerGradient"}, 
              React.DOM.stop( {offset:"0%", style:{ stopColor: '#d9e3cd' }} ),
              React.DOM.stop( {offset:"100%", style:{ stopColor: '#f0f4ec' }} )
            ),
            React.DOM.polygon( {points:docScrollerPoints.map(function(xy) { return xy.join(','); }).join(' '), style:{ fill: 'url(#docScrollerGradient)' }} )
          ),
          React.DOM.div( {style:{ marginTop: -10 }, className:"canvas-docscroller-label"}, Util.formatNumber(dimensions.totalRows))
        )
      );
      return (
        React.DOM.div( {className:"canvas canvas-view-main sframe"}, 
          React.DOM.div( {style:{float: 'left'}}, 
            goToRow,
            docScroller
          ),
          React.DOM.div( {style:{width:dimensions.tableWidth, overflow: 'hidden'}}, 
            React.DOM.table( {className:"sframe-table table table-striped", style:{marginBottom: 0, marginLeft: (-this.state.scrollLeft)}}, 
              React.DOM.thead(null, 
                React.DOM.tr(null, 
                  React.DOM.td( {style:getCellStyle(dimensions.rowHeaderWidth)} ),
                  columns.map(function(col, idx) {
                    var handleClick = function(c) {
                      var selected_column = this.props.selected_variable.name.concat([c.name]);
                      this.props.selectVariable(selected_column);
                    }.bind(this, col);
                    return (
                      React.DOM.th( {key:idx, style:getCellStyle(this.getColumnWidth(col.dtype))}, 
                        React.DOM.div( {className:"canvas-sframe-column-header"} , 
                          React.DOM.a( {href:"javascript:", onClick:handleClick, className:"canvas-sframe-column-title"} , 
                            col.name
                          )
                        )
                      )
                    );
                  }.bind(this))
                )
              )
            )
          ),
          React.DOM.div( {id:"tableArea", style:{ height: dimensions.elementHeight, width: dimensions.tableWidth, overflow: 'auto'}, onScroll:this.scrollTable}, 
            React.DOM.table( {className:"sframe-table table table-striped", style:{ marginTop: dimensions.heightAbove, marginBottom: dimensions.heightBelow }}, 
              React.DOM.tbody(null, 
                d3.range(dimensions.fillerAbove).map(function(i) {
                  // for rows out of range above
                  return getRowHTML(i + dimensions.currentRowStart);
                }.bind(this)),
                this.state.rows.slice(dimensions.currentRowStart - this.state.rowStart, dimensions.currentRowEnd - this.state.rowStart).map(function(row, i) {
                  return getRowHTML(i + dimensions.currentRowStart, row);
                }.bind(this)),
                d3.range(dimensions.fillerBelow).map(function(i) {
                  return getRowHTML(i + dimensions.currentRowStart);
                }.bind(this))
              )
            )
          )
        )
      );
    }
  });

  return {
    View: React.createClass({displayName: 'View',
      shouldComponentUpdate: function(nextProps, nextState) {
        return !Util.deepEquals(this.props, nextProps);
      },
      render: function() {
        if (this.props.ipython == true) {
          return this.transferPropsTo(SummaryView(Util.merge(this.props, this.state)));
        }
        var Tabs = Controls.Tabs;
        var tabContents = [
          [TabularView, Util.merge(this.props, this.state), ''],
          [SummaryView, Util.merge(this.props, this.state), '']
        ];
        return (
          Tabs( {tabs:['Table', 'Summary'], tabContents:tabContents} )
        );
      }
    })
  };
});
