def get_view(obj, params={}):
    """
    Get an object-type specific MVC view for Canvas,
    bound to the object provided.

    Parameters:
    obj | *
      The object to bind to a Canvas view.
    """
    from graphlab.canvas.views.sarray import SArrayView
    from graphlab.canvas.views.sframe import SFrameView
    from graphlab.canvas.views.sgraph import SGraphView
    obj_type = type(obj).__name__ # get the type name of the passed in object
    obj_class_name = obj_type + 'View'
    if obj_class_name in locals():
        obj_class = locals()[obj_type + 'View'] # get the corresponding view class
        return obj_class(obj, params) # instantiate and return
    return None # did not find a view class matching passed in object type

