"""
GraphLab offers a framework for quickly building automated data products in
production.

Explore the detailed functionality via the following API documentation, or
learn to use them through the tutorials on: 
http://www.graphlab.com/products/create/tutorials.html.

"""

__all__ = [ 'Task', 'tasks', 'environments', 'jobs', 'job' ]

# Job
from _job import Job as _Job

# Tasks and pipelines
from _artifact import Task
from _artifact import Pipeline as _Pipeline

import _session
_default_session = _session.open()

import _hadoop_wrap as _hadoop_wrap
from _context import Environment as _Environment

# environment
import environment

# session helpers
tasks = _session.ScopedSession(_default_session, Task)
environments = _session.ScopedSession(_default_session, _Environment)
jobs = _session.ScopedSession(_default_session, _Job)

import job
