r"""
The GraphLab classification toolkit includes models that can be trained for
binary classification. Currently, we support binary classification using linear
SVM.

GraphLab classification models accept training and prediction data in the form
of an :class:`~graphlab.SFrame`. Training datasets should contain a column for
the 'target' variable and one or more columns representing feature variables.
For predictions on new data, the SFrame need not contain the 'target' column.

The :py:class:`~graphlab.svm.SVMModel` model predicts a binary target variable
given one or more feature variables. In an SVM model, the examples are
represented as points in space, mapped so that the examples from the two
classes being classified are divided by linear separator.  Class predictions
for new examples are made based on which side of the separator they fall on.


.. sourcecode:: python

    # Load the data (From an S3 bucket)
    >>> import graphlab as gl
    >>> data =  gl.SFrame('http://s3.amazonaws.com/GraphLab-Datasets/regression/houses.csv')

    # Make sure the target is binary 0/1
    >>> data['expensive'] = data['price'] > 30000
    
    # Make an SVM model
    >>> model = gl.svm.create(data, target='expensive', features=['bath', 'bedroom', 'size'])

    # Here, all columns (other than the target) are used as features.
    >>> model = gl.svm.create(data, target='expensive')

    # Extract the coefficients
    >>> coefficients = model['coefficients']     # an SFrame
    
    # Make predictions (as margins, or class)
    >>> predictions = model.predict(data) 
    >>> predictions = model.predict(data, output_type='margin')       


    >>> results = m.evaluate(data)               # a dictionary
"""

from graphlab.toolkits.classification import svm
