// Tie together all the plot_ JS files into a single dependency

define('plots',
      ['common_util', 'plot_frequency', 'plot_box', 'plot_boxes', 'plot_quantilehist', 'plot_graph'],
      function(Util) {

  var ret = {};
  var args = Array.prototype.slice.call(arguments, 1);
  for (var i=0; i<args.length; i++) {
    for (var j in args[i]) {
      if (args[i].hasOwnProperty(j)) {
        // for every key on the object that defines the plot_ file,
        // copy that key/value pair into our return value
        Util.assert(!(j in ret));
        ret[j] = args[i][j];
      }
    }
  }
  return ret;
});
