/** @jsx React.DOM */
"use strict";

/*
 * This file manages application-global state independently of Canvas
 * Page rendering or the TaskQueue by routing to a runtime-bound location
 * (anyone in the listeners array).
 */

define('state',
      ['common_util'],
      function(Util) {
  var listeners = [];
  return {
    'addListener': function(l) {listeners.push(l);},
    'set': function(state) {
      for (var i=0; i<listeners.length; i++) {
        listeners[i].setState(state);
      }
    }
  }; 
});
